﻿using System.Reflection;
using System.Reflection.Emit;

namespace Robotless.Modules.Utilities.EmitExtensions;

public static class EmitExtension
{
    
    
    public static void LoadLocal(this ILGenerator code, LocalBuilder local)
        => code.Emit(OpCodes.Ldloc, local);
    
    public static void LoadLocalAddress(this ILGenerator code, LocalBuilder local)
        => code.Emit(OpCodes.Ldloca, local);
    
    public static void StoreLocal(this ILGenerator code, LocalBuilder local)
        => code.Emit(OpCodes.Stloc, local);
    
    public static void NewObject(this ILGenerator code, ConstructorInfo constructor)
        => code.Emit(OpCodes.Newobj, constructor);
    
    public static void MethodReturn(this ILGenerator code)
        => code.Emit(OpCodes.Ret);
    
    public static void Call(this ILGenerator code, MethodInfo method)
        => code.Emit(OpCodes.Call, method);
    
    public static void Call(this ILGenerator code, ConstructorInfo constructor)
        => code.Emit(OpCodes.Call, constructor);
    
    public static void CallVirtual(this ILGenerator code, MethodInfo method)
        => code.Emit(OpCodes.Callvirt, method);
}