﻿using System.Collections;
using System.Dynamic;

namespace Robotless.Modules.Utilities;

public class ExpandoDictionary : DynamicObject, IDictionary<string, object?>, IDictionary
{
    private readonly Dictionary<string, object?> _dictionary = new();

    public override bool TryDeleteMember(DeleteMemberBinder binder)
        => _dictionary.Remove(binder.Name);

    public override bool TryGetMember(GetMemberBinder binder, out object? result)
        => _dictionary.TryGetValue(binder.Name, out result);

    public override bool TrySetMember(SetMemberBinder binder, object? value)
    {
        _dictionary[binder.Name] = value;
        return true;
    }
    
    public object? this[string key]
    {
        get => _dictionary[key];
        set => _dictionary[key] = value;
    }

    #region IDictionary<string, object?>

    public void Add(string key, object? value) 
        => ((IDictionary<string, object?>)_dictionary).Add(key, value);

    public bool ContainsKey(string key)
        => ((IDictionary<string, object?>)_dictionary).ContainsKey(key);

    public bool Remove(string key)
        => ((IDictionary<string, object?>)_dictionary).Remove(key);

    public bool TryGetValue(string key, out object? value)
        => ((IDictionary<string, object?>)_dictionary).TryGetValue(key, out value);

    public ICollection<string> Keys => ((IDictionary<string, object?>)_dictionary).Keys;
    
    public ICollection<object?> Values => ((IDictionary<string, object?>)_dictionary).Values;
    
    #endregion

    #region IDictionary
    
    public void Add(object key, object? value)
        => ((IDictionary)_dictionary).Add(key, value);

    public void Clear()
        => ((IDictionary)_dictionary).Clear();

    public bool Contains(object key)
        => ((IDictionary)_dictionary).Contains(key);

    IDictionaryEnumerator IDictionary.GetEnumerator()
        => ((IDictionary)_dictionary).GetEnumerator();

    public void Remove(object key)
        => ((IDictionary)_dictionary).Remove(key);

    public bool IsFixedSize => ((IDictionary)_dictionary).IsFixedSize;

    public bool IsReadOnly => ((IDictionary)_dictionary).IsReadOnly;

    public object? this[object key]
    {
        get => ((IDictionary)_dictionary)[key];
        set => ((IDictionary)_dictionary)[key] = value;
    }

    ICollection IDictionary.Keys => ((IDictionary)_dictionary).Keys;

    ICollection IDictionary.Values => ((IDictionary)_dictionary).Values;
    
    #endregion

    #region ICollection<KeyValuePair<string, object?>>
    
    public void Add(KeyValuePair<string, object?> item)
        => ((ICollection<KeyValuePair<string, object?>>)_dictionary).Add(item);

    public bool Contains(KeyValuePair<string, object?> item)
        => ((ICollection<KeyValuePair<string, object?>>)_dictionary).Contains(item);

    public void CopyTo(KeyValuePair<string, object?>[] array, int arrayIndex)
        => ((ICollection<KeyValuePair<string, object?>>)_dictionary).CopyTo(array, arrayIndex);

    public bool Remove(KeyValuePair<string, object?> item)
        => ((ICollection<KeyValuePair<string, object?>>)_dictionary).Remove(item);

    public int Count => ((ICollection<KeyValuePair<string, object?>>)_dictionary).Count;
    
    #endregion

    #region ICollection
    
    public void CopyTo(Array array, int index)
        => ((ICollection)_dictionary).CopyTo(array, index);

    public bool IsSynchronized => ((ICollection)_dictionary).IsSynchronized;

    public object SyncRoot => ((ICollection)_dictionary).SyncRoot;

    #endregion
    
    // IEnumerable
    IEnumerator IEnumerable.GetEnumerator()
        => ((IEnumerable)_dictionary).GetEnumerator();
    
    // IEnumerable<KeyValuePair<string, object?>>
    IEnumerator<KeyValuePair<string, object?>> IEnumerable<KeyValuePair<string, object?>>.GetEnumerator()
        => ((IEnumerable<KeyValuePair<string, object?>>)_dictionary).GetEnumerator();
    
    IEnumerator<KeyValuePair<string, object?>> GetEnumerator()
        => ((IEnumerable<KeyValuePair<string, object?>>)_dictionary).GetEnumerator();
}