using System.Runtime.CompilerServices;

namespace Robotless.Modules.Utilities;

public static unsafe class ObjectCopier
{
    public static void ShallowCopy<TObject>(ref TObject destination, ref TObject source)
    {
        Unsafe.Copy(ref destination, Unsafe.AsPointer(ref source));
    }
    
    public static TObject ShallowClone<TObject>(ref TObject target)
    {
        var instance = (TObject)RuntimeHelpers.GetUninitializedObject(typeof(TObject));
        Unsafe.Copy(ref instance, Unsafe.AsPointer(ref target));
        return instance;
    }
}