﻿namespace Robotless.Modules.Utilities.Referencing;

public interface IReference
{
    /// <summary>
    /// Type of the content.
    /// </summary>
    Type ValueType { get; }
    
    /// <summary>
    /// Whether this reference is still valid.
    /// </summary>
    bool IsValid { get; }
}

public interface IReference<TContent> : IReference
{
    Type IReference.ValueType => typeof(TContent);

    /// <summary>
    /// Referenced content.
    /// </summary>
    ref TContent Value { get; }
}

public static class ReferenceExtension
{
    public static ref TContent Access<TContent>(this IReference ambiguousReference)
    {
        if (ambiguousReference is IReference<TContent> specificReference)
            return ref specificReference.Value;
        throw new InvalidOperationException(
            $"Specified reference has content type {ambiguousReference.ValueType} instead of {typeof(TContent)}.");
    }
}