﻿namespace Robotless.Modules.Utilities.Referencing;

public partial class RefCollection<TValue>
{
    private class RefCollectionReference : IReference<TValue>
    {
        private readonly RefCollection<TValue> _collection;
    
        private readonly int _version;
    
        private readonly int _index;
    
        public void Deconstruct(out RefCollection<TValue> container, out int version, out int index)
        {
            container = _collection;
            version = _version;
            index = _index;
        }
        
        /// <summary>
        /// Cached validity.
        /// </summary>
        private bool _valid;
    
        /// <summary>
        /// Check whether this reference is still valid.
        /// This property will no long query the validity from the group once it is invalid.
        /// </summary>
        public bool IsValid
        {
            get
            {
                if (!_valid) 
                    return false;
                _valid = _collection.Contains(this);
                return _valid;
            }
        }
    
        /// <summary>
        /// Access the referenced content.
        /// </summary>
        /// <returns>Reference to the content.</returns>
        /// <exception cref="Exception"></exception>
        public ref TValue Value
        {
            get
            {
                if (!IsValid)
                    throw new InvalidOperationException("Cannot access the value by reference: reference is invalid.");
                return ref _collection._elements[_index].Value;
            }
        }
    
        internal RefCollectionReference(RefCollection<TValue> collection, int version, int index)
        {
            _collection = collection;
            _version = version;
            _index = index;
            _valid = true;
        }
    }
}