namespace Robotless.Modules.Utilities;

public class ScopeAction(Action action) : IDisposable
{
    private bool _disposed;

    public void Dispose()
    {
        ObjectDisposedException.ThrowIf(_disposed, typeof(ScopeAction));
        GC.SuppressFinalize(this);
        action();
        _disposed = true;
    }
}