﻿using System.Text;

namespace Robotless.Modules.Utilities;

public static class TimeSpanSmartFormatter
{
    public static string ToSmartString(this TimeSpan duration, int decimalPlaces = 2, bool chained = false)
    {
        if (!chained)
        {
            if (duration.TotalNanoseconds < 1000)
                return $"{FormatValue(duration.TotalNanoseconds)}ns";
            if (duration.TotalMicroseconds < 1000)
                return $"{FormatValue(duration.TotalMicroseconds)}μs";
            if (duration.TotalMilliseconds < 1000)
                return $"{FormatValue(duration.TotalMilliseconds)}ms";
            if (duration.TotalSeconds < 60)
                return $"{FormatValue(duration.TotalSeconds)}sec";
            if (duration.TotalMinutes < 60)
                return $"{FormatValue(duration.TotalMinutes)}min";
            return duration.TotalHours < 24 ? 
                $"{FormatValue(duration.TotalHours)}h" : 
                $"{FormatValue(duration.TotalDays)}d";
        }

        var text = new StringBuilder();
        if (duration.TotalDays >= 1)
        {
            text.Append($"{duration.Days}d");
            duration -= TimeSpan.FromDays(duration.Days);
        }
        if (duration.TotalHours >= 1)
        {
            text.Append($"{duration.Hours}h");
            duration -= TimeSpan.FromHours(duration.Hours);
        }
        if (duration.TotalMinutes >= 1)
        {
            text.Append($"{duration.Minutes}m");
            duration -= TimeSpan.FromMinutes(duration.Minutes);
        }
        if (duration.TotalSeconds >= 1)
        {
            text.Append($"{duration.Seconds}s");
            duration -= TimeSpan.FromSeconds(duration.Seconds);
        }
        if (duration.TotalMilliseconds >= 1)
        {
            text.Append($"{duration.Milliseconds}ms");
            duration -= TimeSpan.FromMilliseconds(duration.Milliseconds);
        }
        if (duration.TotalMicroseconds >= 1)
        {
            text.Append($"{duration.Microseconds}μs");
            duration -= TimeSpan.FromMicroseconds(duration.Microseconds);
        }
        text.Append($"{duration.Nanoseconds}ns");
        return text.ToString();

        string FormatValue(double value) => value.ToString($"F{decimalPlaces}");
    }
}