﻿using System.Runtime.InteropServices;

namespace Robotless.Modules.Utilities;

public static class TypeSizeExtension
{
    /// <summary>
    /// Read the instance type from the type descriptor.
    /// </summary>
    /// <param name="type">Type.</param>
    /// <returns>Type instance size.</returns>
    public static int InstanceSize(this Type type)
        => Marshal.ReadInt32(type.TypeHandle.Value, 4);
}

public static class InstanceSize
{
    public static int Of(Type type) => Marshal.ReadInt32(type.TypeHandle.Value, 4);

    public static int Of<TType>() => Of(typeof(TType));
}