using Robotless.Framework;
using Robotless.Kernel;
using Robotless.Modules.Developing;

namespace Robotless.Platform.Test.Modules.Framework;

[TestFixture, TestOf(typeof(DevelopmentWorkspace))]
public class TestWorkspace
{
    private class StubComponent : Component
    {}
    
    private class StubEntityWithEnsuringComponents : Entity
    {
        [ComponentDependency(IsEnsuring = true)]
        public required StubComponent Component { get; init; }
    }
    
    [Test]
    public void GetInjection_Entity_EnsureComponents()
    {
        var workspace = new DevelopmentWorkspace();

        var entity = workspace.CreateObject<StubEntityWithEnsuringComponents>();
        
        Assert.That(entity.Component, Is.TypeOf<StubComponent>());
    }
}