﻿using System.Collections;

namespace Robotless.Platform.Test.Modules.Serializing.Containers;

public class StubCollection<TValue>(IEnumerable<TValue> values) : ICollection<TValue>
{
    private readonly List<TValue> _list = [..values];
    
    public StubCollection() : this([])
    {}
    
    IEnumerator IEnumerable.GetEnumerator()
    {
        return GetEnumerator();
    }

    public IEnumerator<TValue> GetEnumerator() => _list.GetEnumerator();

    public void Add(TValue item) => _list.Add(item);

    public void Clear() => _list.Clear();

    public bool Contains(TValue item) => _list.Contains(item);

    public void CopyTo(TValue[] array, int arrayIndex) => _list.CopyTo(array, arrayIndex);

    public bool Remove(TValue item) => _list.Remove(item);

    public int Count => _list.Count;
    
    public bool IsReadOnly => ((ICollection<TValue>)_list).IsReadOnly;
}