﻿using System.Collections;

namespace Robotless.Platform.Test.Modules.Serializing.Containers;

public class StubEnumerable<TValue>(IEnumerable<TValue> values) : IEnumerable<TValue>
{
    private readonly List<TValue> _list = [..values];
    
    public StubEnumerable() : this([])
    {}
    
    IEnumerator IEnumerable.GetEnumerator() => GetEnumerator();

    public IEnumerator<TValue> GetEnumerator() => _list.GetEnumerator();
}