﻿using System.Collections;

namespace Robotless.Platform.Test.Modules.Serializing.Containers;

public class StubReadOnlyCollection<TValue>(IEnumerable<TValue> values) : IReadOnlyCollection<TValue>
{
    private readonly List<TValue> _list = [..values];
    
    public StubReadOnlyCollection() : this([])
    {}
    
    IEnumerator IEnumerable.GetEnumerator() => GetEnumerator();

    public IEnumerator<TValue> GetEnumerator() => _list.GetEnumerator();

    public int Count => _list.Count;
}