﻿using System.Collections;
using System.Diagnostics.CodeAnalysis;

namespace Robotless.Platform.Test.Modules.Serializing.Containers;

public class StubReadOnlyDictionary<TKey, TValue>(IEnumerable<KeyValuePair<TKey, TValue>> pairs) :
    IReadOnlyDictionary<TKey, TValue>
    where TKey : notnull
{
    private readonly Dictionary<TKey, TValue> _dictionary = new(pairs);
    
    public StubReadOnlyDictionary() : this([])
    {}
    
    IEnumerator IEnumerable.GetEnumerator()
    {
        return GetEnumerator();
    }

    public IEnumerator<KeyValuePair<TKey, TValue>> GetEnumerator() => _dictionary.GetEnumerator();

    public int Count => _dictionary.Count;
    
    public bool ContainsKey(TKey key) => _dictionary.ContainsKey(key);

    public bool TryGetValue(TKey key, [MaybeNullWhen(false)] out TValue value)
        => _dictionary.TryGetValue(key, out value);

    public TValue this[TKey key] => _dictionary[key];

    public IEnumerable<TKey> Keys => _dictionary.Keys;
    
    public IEnumerable<TValue> Values => _dictionary.Values;
}