﻿using System.Collections;

namespace Robotless.Platform.Test.Modules.Serializing.Containers;

public class StubReadOnlyList<TValue>(IEnumerable<TValue> values) : IReadOnlyList<TValue>
{
    private readonly List<TValue> _list = [..values];
    
    public StubReadOnlyList() : this([])
    {}
    
    IEnumerator IEnumerable.GetEnumerator()
    {
        return GetEnumerator();
    }

    public IEnumerator<TValue> GetEnumerator() => _list.GetEnumerator();

    public int Count => _list.Count;

    public TValue this[int index] => _list[index];
}