﻿using System.Collections;

namespace Robotless.Platform.Test.Modules.Serializing.Containers;

public class StubReadOnlySet<TValue>(IEnumerable<TValue> values) : IReadOnlySet<TValue>
{
    private readonly HashSet<TValue> _set = [..values];
    
    public StubReadOnlySet() : this([])
    {}
    
    IEnumerator IEnumerable.GetEnumerator()
    {
        return GetEnumerator();
    }

    public IEnumerator<TValue> GetEnumerator() => _set.GetEnumerator();

    public int Count => _set.Count;

    public bool Contains(TValue item) => _set.Contains(item);

    public bool IsProperSubsetOf(IEnumerable<TValue> other) => _set.IsProperSubsetOf(other);

    public bool IsProperSupersetOf(IEnumerable<TValue> other) => _set.IsProperSupersetOf(other);

    public bool IsSubsetOf(IEnumerable<TValue> other) => _set.IsSubsetOf(other);

    public bool IsSupersetOf(IEnumerable<TValue> other) => _set.IsSupersetOf(other);

    public bool Overlaps(IEnumerable<TValue> other) => _set.Overlaps(other);

    public bool SetEquals(IEnumerable<TValue> other) => _set.SetEquals(other);
}