﻿using Robotless.Modules.Serializing;
using Robotless.Modules.Serializing.Serializers;
using Robotless.Modules.Serializing.Serializers.Containers;
using Robotless.Modules.Serializing.Serializers.Primitives;

namespace Robotless.Platform.Test.Modules.Serializing.Containers;

[TestFixture, TestOf(typeof(ContainerSerializerProvider))]
public class TestContainerSerializerProvider
{
    [TestCase(typeof(KeyValuePair<int, int>), ExpectedResult = typeof(KeyValuePairSerializer<int, int>))]
    [TestCase(typeof(KeyValuePair<string, int>), ExpectedResult = typeof(StringValuePairSerializer<int>))]
    [TestCase(typeof(IDictionary<int, int>), ExpectedResult = typeof(DictionarySerializer<int, int>))]
    [TestCase(typeof(IReadOnlyDictionary<int, int>), ExpectedResult = typeof(ReadOnlyDictionarySerializer<int, int>))]
    [TestCase(typeof(IDictionary<string, int>), ExpectedResult = typeof(StringDictionarySerializer<int>))]
    [TestCase(typeof(IReadOnlyDictionary<string, int>),
        ExpectedResult = typeof(ReadOnlyStringDictionarySerializer<int>))]
    [TestCase(typeof(IList<int>), ExpectedResult = typeof(ListSerializer<int>))]
    [TestCase(typeof(IReadOnlyList<int>), ExpectedResult = typeof(ReadOnlyListSerializer<int>))]
    [TestCase(typeof(ISet<int>), ExpectedResult = typeof(SetSerializer<int>))]
    [TestCase(typeof(IReadOnlySet<int>), ExpectedResult = typeof(ReadOnlySetSerializer<int>))]
    [TestCase(typeof(ICollection<int>), ExpectedResult = typeof(CollectionSerializer<int>))]
    [TestCase(typeof(IReadOnlyCollection<int>), ExpectedResult = typeof(ReadOnlyCollectionSerializer<int>))]
    [TestCase(typeof(IEnumerable<int>), ExpectedResult = typeof(EnumerableSerializer<int>))]
    [Test]
    public Type? GetSerializerType_SpecificSerializerTypeShouldMatch(Type containerType)
    {
        var context = new SerializationContext()
            .WithPrimitiveSerializers()
            .WithContainerSerializers();
        return context.GetSerializer(containerType)?.GetType();
    }

    [TestCase(typeof(Dictionary<int, int>),
        ExpectedResult = typeof(SerializerAdapter<Dictionary<int, int>, 
            IDictionary<int, int>, DictionarySerializer<int, int>>))]
    [TestCase(typeof(Dictionary<string, int>),
        ExpectedResult = typeof(SerializerAdapter<Dictionary<string, int>, 
            IDictionary<string, int>, StringDictionarySerializer<int>>))]
    [TestCase(typeof(List<int>),
        ExpectedResult = typeof(SerializerAdapter<List<int>, IList<int>, ListSerializer<int>>))]
    [TestCase(typeof(HashSet<int>),
        ExpectedResult = typeof(SerializerAdapter<HashSet<int>, ISet<int>, SetSerializer<int>>))]
    [TestCase(typeof(StubCollection<int>),
        ExpectedResult = typeof(SerializerAdapter<StubCollection<int>, 
            ICollection<int>, CollectionSerializer<int>>))]
    [TestCase(typeof(StubReadOnlyList<int>), ExpectedResult = null)]
    [TestCase(typeof(StubReadOnlySet<int>), ExpectedResult = null)]
    [TestCase(typeof(StubReadOnlyCollection<int>), ExpectedResult = null)]
    [TestCase(typeof(StubEnumerable<int>), ExpectedResult = null)]
    [Test]
    public Type? GetSerializerType_SubtypeSerializerTypeShouldMatch(Type containerType)
    {
        var context = new SerializationContext()
            .WithPrimitiveSerializers()
            .WithContainerSerializers();
        return context.GetSerializer(containerType)?.GetType();
    }

    [TestCase(typeof(KeyValuePair<int, int>))]
    [TestCase(typeof(KeyValuePair<string, int>))]
    [TestCase(typeof(IDictionary<int, int>))]
    [TestCase(typeof(IReadOnlyDictionary<int, int>))]
    [TestCase(typeof(IDictionary<string, int>))]
    [TestCase(typeof(IReadOnlyDictionary<string, int>))]
    [TestCase(typeof(IList<int>))]
    [TestCase(typeof(IReadOnlyList<int>))]
    [TestCase(typeof(ISet<int>))]
    [TestCase(typeof(IReadOnlySet<int>))]
    [TestCase(typeof(ICollection<int>))]
    [TestCase(typeof(IReadOnlyCollection<int>))]
    [TestCase(typeof(IEnumerable<int>))]
    public void GetSerializer_SpecificSerializerShouldNotBeNull(Type containerType)
    {
        var context = new SerializationContext()
            .WithPrimitiveSerializers()
            .WithContainerSerializers();
        ISnapshotSerializer? serializer = null;
        Assert.DoesNotThrow(() => serializer = context.GetSerializer(containerType));
        Assert.That(serializer, Is.Not.Null);
    }

    [TestCase(typeof(Dictionary<int, int>))]
    [TestCase(typeof(Dictionary<string, int>))]
    [TestCase(typeof(List<int>))]
    [TestCase(typeof(HashSet<int>))]
    [TestCase(typeof(StubCollection<int>))]
    public void GetSerializer_SubtypeSerializerShouldNotBeNull(Type containerType)
    {
        var context = new SerializationContext()
            .WithPrimitiveSerializers()
            .WithContainerSerializers();
        ISnapshotSerializer? serializer = null;
        Assert.DoesNotThrow(() => serializer = context.GetSerializer(containerType));
        Assert.That(serializer, Is.Not.Null);
    }
}