﻿using MongoDB.Bson.IO;
using Robotless.Modules.Serializing;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Platform.Test.Modules.Serializing;

public class FakeSpecificSerializer<TTarget> : SnapshotSerializerBase<TTarget>
{
    protected override void OnLoadSnapshot(ref TTarget target, SnapshotReader reader)
    {
        throw new Exception();
    }

    protected override void OnSaveSnapshot(in TTarget target, IBsonWriter writer)
    {
        throw new Exception();
    }
}

public class FakeSpecificSerializer<TTarget, TDependency1, TDependency2>(
    ISnapshotSerializer<TDependency1> dependency1,
    ISnapshotSerializer<TDependency2> dependency2) : SnapshotSerializerBase<TTarget>
{
    public ISnapshotSerializer<TDependency1> DependencySerializer1 { get; } = dependency1;
    
    public ISnapshotSerializer<TDependency2> DependencySerializer2 { get; } = dependency2;
    
    protected override void OnLoadSnapshot(ref TTarget target, SnapshotReader reader)
    {
        throw new Exception();
    }

    protected override void OnSaveSnapshot(in TTarget target, IBsonWriter writer)
    {
        throw new Exception();
    }
}