﻿using MongoDB.Bson.IO;
using Robotless.Modules.Serializing;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Platform.Test.Modules.Serializing.Generator;

public class StubCustomizedPostSerializationStruct : ICustomizedSerialization
{
    private int _loaderInvokedTimes = 0;
    
    private int _saverInvokedTimes = 0;
    
    public int LoaderInvokedTimes => _loaderInvokedTimes;
    
    public int SaverInvokedTimes => _saverInvokedTimes;
    
    void ICustomizedSerialization.OnLoadSnapshot(SnapshotReader reader, ISerializationProvider context)
    {
        ++_loaderInvokedTimes;
    }

    void ICustomizedSerialization.OnSaveSnapshot(IBsonWriter writer, ISerializationProvider context)
    {
        ++_saverInvokedTimes;
    }
}