﻿using MongoDB.Bson;
using MongoDB.Bson.IO;
using Robotless.Modules.Serializing;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Platform.Test.Modules.Serializing.Generator;

public class StubMemberFilterTarget : ICustomizedSerialization
{
    public int Field = 0;
    
    public int Property { get; set; } = 0;
    
    public int GetAndInitProperty { get; init; } = 0;
    
    public const double ConstNumberField = 0;
    
    public readonly double ReadOnlyNumberField = 0;
    
    public double GetterOnlyProperty { get; } = 0;
    
    public double PrivateSetterProperty { get; private set; } = 0;
    
#pragma warning disable CS0169 // Field is never used
    private double _privateField;
#pragma warning restore CS0169 // Field is never used
    
    public double SetterOnlyProperty
    {
        set => throw new Exception("SetterOnlyProperty should not be set.");
    }
    
    public double InitOnlyProperty
    {
        init => throw new Exception("SetterOnlyProperty should not be set.");
    }

    public void OnLoadSnapshot(SnapshotReader reader, ISerializationProvider context)
    {
        reader.SkipToEndOfDocument();
    }

    public void OnSaveSnapshot(IBsonWriter writer, ISerializationProvider context)
    {}
}