﻿using MongoDB.Bson;
using MongoDB.Bson.IO;
using Robotless.Modules.Serializing;
using Robotless.Modules.Serializing.Serializers.Containers;
using Robotless.Modules.Serializing.Serializers.Primitives;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Platform.Test.Modules.Serializing.Schema;

[TestFixture]
public class TestContainerSchema
{
    [Test]
    public void GenerateSchema_ContainerSerializerBase()
    {
        var context = new SerializationContext()
            .WithPrimitiveSerializers()
            .WithContainerSerializers();
        SchemaWriterFactory.CreateSchema(context.RequireSerializer<IList<int>>(), out var schema);
        Assert.That(schema, Is.EqualTo(new BsonDocument
        {
            { "type", "array" },
            {
                "items", new BsonDocument
                {
                    { "type", "integer" }
                }
            }
        }));
    }

    [Test]
    public void GenerateSchema_ContainerRedirectorBase()
    {
        var context = new SerializationContext()
            .WithPrimitiveSerializers()
            .WithContainerSerializers();
        SchemaWriterFactory.CreateSchema(context.RequireSerializer<ISet<int>>(), out var schema);
        Assert.That(schema, Is.EqualTo(new BsonDocument
        {
            { "type", "array" },
            {
                "items", new BsonDocument
                {
                    { "type", "integer" }
                }
            }
        }));
    }

    [Test]
    public void GenerateSchema_KeyValuePair()
    {
        var context = new SerializationContext()
            .WithPrimitiveSerializers()
            .WithContainerSerializers();
        SchemaWriterFactory.CreateSchema(context.RequireSerializer<KeyValuePair<int, int>>(), 
            out var schema);
        Assert.That(schema, Is.EqualTo(new BsonDocument
        {
            { "type", "object" },
            {
                "properties", new BsonDocument
                {
                    {
                        "!Key", new BsonDocument
                        {
                            { "type", "integer" }
                        }
                    },
                    {
                        "!Value", new BsonDocument
                        {
                            { "type", "integer" }
                        }
                    }
                }
            },
            {
                "required", new BsonArray { "!Key", "!Value" }
            }
        }));
    }

    [Test]
    public void GenerateSchema_StringValuePair()
    {
        var context = new SerializationContext()
            .WithPrimitiveSerializers()
            .WithContainerSerializers();
        SchemaWriterFactory.CreateSchema(context.RequireSerializer<KeyValuePair<string, int>>(), 
            out var schema);
        Assert.That(schema, Is.EqualTo(new BsonDocument
            {
                {
                    "additionalProperties", new BsonDocument
                    {
                        { "type", "integer" }
                    }
                }
            }
        ));
    }

    [Test]
    public void GenerateSchema_Dictionary()
    {
        var context = new SerializationContext()
            .WithPrimitiveSerializers()
            .WithContainerSerializers();
        SchemaWriterFactory.CreateSchema(context.RequireSerializer<Dictionary<int, int>>(), 
            out var schema);
        Assert.That(schema, Is.EqualTo(new BsonDocument
        {
            { "type", "array" },
            {
                "items", new BsonDocument
                {
                    { "type", "object" },
                    {
                        "properties", new BsonDocument
                        {
                            {
                                "!Key", new BsonDocument
                                {
                                    { "type", "integer" }
                                }
                            },
                            {
                                "!Value", new BsonDocument
                                {
                                    { "type", "integer" }
                                }
                            }
                        }
                    },
                    { "required", new BsonArray { "!Key", "!Value" } }
                }
            },
        }));
    }

    [Test]
    public void GenerateSchema_StringDictionary()
    {
        var context = new SerializationContext()
            .WithPrimitiveSerializers()
            .WithContainerSerializers();
        SchemaWriterFactory.CreateSchema(context.RequireSerializer<Dictionary<string, int>>(), 
            out var schema);
        Assert.That(schema, Is.EqualTo(new BsonDocument
            {
                {
                    "additionalProperties", new BsonDocument
                    {
                        { "type", "integer" }
                    }
                }
            }
        ));
    }
}