﻿using MongoDB.Bson;
using MongoDB.Bson.IO;
using Robotless.Modules.Serializing;
using Robotless.Modules.Serializing.Serializers.Primitives;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Platform.Test.Modules.Serializing.Schema;

[TestFixture]
public class TestEmbeddedSchema
{
    [Test]
    public void GenerateSchema_Array_Integer()
    {
        var context = new SerializationContext()
            .WithPrimitiveSerializers();
        var serializer = context.RequireSerializer<int[]>();
        SchemaWriterFactory.CreateSchema(serializer, out var document);
        Assert.That(document, Is.EqualTo(new BsonDocument
        {
            ["type"] = "array",
            ["items"] = new BsonDocument()
            {
                ["type"] = "integer"
            }
        }));
    }

    [Test]
    public void GenerateSchema_Matrix_Integer()
    {
        var context = new SerializationContext()
            .WithPrimitiveSerializers();
        var serializer = context.RequireSerializer<int[,]>();
        SchemaWriterFactory.CreateSchema(serializer, out var document);
        Assert.That(document, Is.EqualTo(new BsonDocument
        {
            ["type"] = "object",
            ["properties"] = new BsonDocument()
            {
                ["!Shape"] = new BsonDocument()
                {
                    ["type"] = "array",
                    ["items"] = new BsonDocument()
                    {
                        ["type"] = "integer"
                    }
                },
                ["!Values"] = new BsonDocument()
                {
                    ["type"] = "array",
                    ["items"] = new BsonDocument()
                    {
                        ["type"] = "array",
                        ["items"] = new BsonDocument()
                        {
                            ["type"] = "integer"
                        }
                    }
                }
            }
        }));
    }
}