﻿using MongoDB.Bson;
using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Serializers.Primitives;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Platform.Test.Modules.Serializing.Schema;

[TestFixture]
public class TestPrimitiveSchema
{
    [Test]
    public void GenerateSchema_String()
    {
        SchemaWriterFactory.CreateSchema(StringSerializer.Shared, out var document);
        Assert.That(document, Is.EqualTo(new BsonDocument
        {
            { "type", "string" }
        }));
    }
    
    [Test]
    public void GenerateSchema_Int32()
    {
        SchemaWriterFactory.CreateSchema(Integer32Serializer.Shared, out var document);
        Assert.That(document, Is.EqualTo(new BsonDocument
        {
            { "type", "integer" }
        }));
    }
}