﻿using MongoDB.Bson;
using Robotless.Modules.Serializing;
using Robotless.Modules.Serializing.Serializers.Containers;
using Robotless.Modules.Serializing.Serializers.Primitives;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Platform.Test.Modules.Serializing.Schema;

[TestFixture, TestOf(typeof(SerializerGenerator))]
public class TestSerializerGenerator
{
    [Test]
    public void GenerateJsonSchema()
    {
        var context = new SerializationContext()
            .WithPrimitiveSerializers()
            .WithContainerSerializers()
            .WithGenerator();
        
        var serializer = context.RequireSerializer<StubTargetClass>();
        SchemaWriterFactory.CreateSchema(serializer, out var document);
        
        Assert.That(document, Is.EqualTo(new BsonDocument
        {
            ["type"] = "object",
            ["properties"] = new BsonDocument()
            {
                ["NumberProperty"] = new BsonDocument()
                {
                    ["type"] = "integer"
                },
                ["StringProperty"] = new BsonDocument()
                {
                    ["type"] = "string"
                },
                ["GetAndInitNumberProperty"] = new BsonDocument()
                {
                    ["type"] = "integer"
                },
                ["NumberField"] = new BsonDocument()
                {
                    ["type"] = "integer",
                },
                ["StringField"] = new BsonDocument()
                {
                    ["type"] = "string"
                },
            },
            ["required"] = new BsonArray()
            {
                "NumberProperty",
                "StringProperty",
                "GetAndInitNumberProperty",
                "NumberField",
                "StringField"
            },
            ["additionalProperties"] = false
        }));
    }
}