﻿using MongoDB.Bson.IO;
using Robotless.Modules.Serializing;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Platform.Test.Modules.Serializing;

[TestFixture, TestOf(typeof(UsingSnapshotSerializerAttribute))]
public class TestSnapshotSerializerAttribute
{
    [UsingSnapshotSerializer(typeof(FakeStubClassSerializer))]
    private class StubClassWithAttribute
    {}
    
    private class FakeStubClassSerializer : ISnapshotSerializer<StubClassWithAttribute>
    {
        public void GenerateJsonSchema(SchemaWriter schema)
        {}

        public void NewInstance(out StubClassWithAttribute target)
        {
            target = default!;
        }

        public void LoadSnapshot(ref StubClassWithAttribute target, SnapshotReader reader)
        {}

        public void SaveSnapshot(in StubClassWithAttribute target, IBsonWriter writer)
        {}
    }
    
    [Test]
    public void DesignateSerializer_ShouldMatch()
    {
        var context = new SerializationContext();
        
        var serializerType = context.GetSerializer(typeof(StubClassWithAttribute))?.GetType();
        
        Assert.That(serializerType, Is.EqualTo(typeof(FakeStubClassSerializer)));
    }
}