# Power of Augmented Replicas in OOD detection

This is the source code for the Power of Augmented Replicas paper. 
The code is based on:
ICML 2022 paper [Out-of-distribution Detection with Deep Nearest Neighbors](https://arxiv.org/abs/2204.06507)
by Yiyou Sun, Yifei Ming, Xiaojin Zhu and Yixuan Li.
ICCV2023 paper [Nearest Neighbor Guidance for Out-of-Distribution Detection] (https://arxiv.org/abs/2309.14888)
by Jaewoo Park, Yoon Gyo Jung and Andrew Beng Jin Teoh1

## Usage

### 1. Dataset Preparation for Large-scale Experiment 

#### In-distribution dataset

Please download [MedMNIST]

```
pip install medmnist
```

#### Out-of-distribution dataset

[iNaturalist](https://arxiv.org/pdf/1707.06642.pdf), 
[SUN](https://vision.princeton.edu/projects/2010/SUN/paper.pdf), 
[Places](http://places2.csail.mit.edu/PAMI_places.pdf), 
and [Textures](https://arxiv.org/pdf/1311.3618.pdf), 


For iNaturalist, SUN, and Places, Sun et al. have sampled 10,000 images from the selected concepts for each dataset,
which can be download via the following links:
```bash
wget http://pages.cs.wisc.edu/~huangrui/imagenet_ood_dataset/iNaturalist.tar.gz
wget http://pages.cs.wisc.edu/~huangrui/imagenet_ood_dataset/SUN.tar.gz
wget http://pages.cs.wisc.edu/~huangrui/imagenet_ood_dataset/Places.tar.gz
```

For Textures, we use the entire dataset, which can be downloaded from their
[original website](https://www.robots.ox.ac.uk/~vgg/data/dtd/).

Please put all downloaded OOD datasets into `./datasets/ood_data`.

### 2. Dataset Preparation for CIFAR Experiment 

#### In-distribution dataset

The downloading process will start immediately upon running. 

#### Out-of-distribution dataset


We provide links and instructions to download each dataset:

* [SVHN](http://ufldl.stanford.edu/housenumbers/test_32x32.mat): download it and place it in the folder of `datasets/ood_data/svhn`. Then run `python select_svhn_data.py` to generate test subset.
* [Textures](https://www.robots.ox.ac.uk/~vgg/data/dtd/download/dtd-r1.0.1.tar.gz): download it and place it in the folder of `datasets/ood_data/dtd`.
* [Places365](http://data.csail.mit.edu/places/places365/test_256.tar): download it and place it in the folder of `datasets/ood_data/places365/test_subset`. We randomly sample 10,000 images from the original test dataset. 
* [LSUN](https://www.dropbox.com/s/fhtsw1m3qxlwj6h/LSUN.tar.gz): download it and place it in the folder of `datasets/ood_data/LSUN`.
* [iSUN](https://www.dropbox.com/s/ssz7qxfqae0cca5/iSUN.tar.gz): download it and place it in the folder of `datasets/ood_data/iSUN`.

[//]: # (For example, run the following commands in the **root** directory to download **LSUN**:)

[//]: # (```)

[//]: # (cd datasets/ood_datasets)

[//]: # (wget https://www.dropbox.com/s/fhtsw1m3qxlwj6h/LSUN.tar.gz)

[//]: # (tar -xvzf LSUN.tar.gz)

[//]: # (```)



## Preliminaries
It is tested under Ubuntu Linux and Python 3.7 environment, and requries some packages to be installed:
* [PyTorch](https://pytorch.org/)
* [scipy](https://github.com/scipy/scipy)
* [numpy](http://www.numpy.org/)
* [sklearn](https://scikit-learn.org/stable/)
* [faiss](https://github.com/facebookresearch/faiss)
* [ylib](https://github.com/sunyiyou/ylib) (Manually download and copy to the current folder)

## Demo
`./demo_cifar.sh` and `./demo_pathmnist.sh` scripts are used to perform the studies. The scripts
use sbatch to execute the code as we use slurm (i.e., Simple Linux Utility for Resource Management). 
In case you do not use, change `sbatch` command to `bash`.

### 1. Demo code for cifar Experiment 

Run `./demo_cifar.sh`.

### 2. Demo code for PathMNIST Experiment 

Run `./demo_pathmnist.sh`.


## Citation


Our code uses code from:

```
@article{sun2022knnood,
  title={Out-of-distribution Detection with Deep Nearest Neighbors},
  author={Sun, Yiyou and Ming, Yifei and Zhu, Xiaojin and Li, Yixuan},
  journal={ICML},
  year={2022}
}
```

```
@article{park2023nearest,
  title={Nearest neighbor guidance for out-of-distribution detection},
  author={Park, Jaewoo and Jung, Yoon Gyo and Teoh, Andrew Beng Jin},
  journal={IEEE/CVF International Conference on Computer Vision},
  year={2023}
}
```
