# Telecom Environment Data

This directory contains JSON data files for the telecom environment simulation.

## Data Files

### customers.json
Contains customer account information including:
- Personal details (name, contact info, address)
- Account information (account number, type, status)
- Service subscriptions
- Device associations
- Billing preferences

### services.json
Defines available telecom services including:
- Mobile plans (unlimited, family, business, basic, senior)
- Internet services (fiber, cable at various speeds)
- TV packages (premium, basic, sports)
- Additional services (business phone, home security)

### devices.json
Contains information about customer devices:
- Mobile phones (iPhone, Android devices)
- Networking equipment (routers, modems)
- TV equipment (smart TVs, cable boxes)
- Business equipment (conference phones, security systems)

### billing.json
Tracks billing and payment information:
- Current account balances
- Payment history
- Monthly charges breakdown
- Auto-pay and paperless preferences

### network_status.json
Real-time network status information:
- Regional service status
- Current outages
- Planned maintenance
- Service quality metrics

### support_tickets.json
Customer support ticket tracking:
- Open, in-progress, and closed tickets
- Priority levels and categories
- Agent assignments
- Resolution notes and customer satisfaction

## Usage

This data is loaded by the telecom environment to simulate realistic customer service scenarios for telecommunications providers.
