from tau_trait.types import Task, Action

TASKS_TEST = [
    Task(
        annotator="0",
        user_id="john_smith_1234",
        instruction="""
        You are John Smith, customer ID john_smith_1234. You want to figure out your account information, specifically 
        your account number and devices you have. You've noticed that your internet has been quite slow recently, and 
        want to get some advice on how to fix the issue. Finally, you want to check your current billing details to 
        see what you are paying monthly for your services.
        """,
        actions=[
            Action(name="get_customer_details", kwargs={"customer_id": "john_smith_1234"}),
            Action(name="troubleshoot_device", kwargs={"device_id": "router_wifi6", "issue": "slow internet speeds"}),
            Action(name="get_billing_details", kwargs={"customer_id": "john_smith_1234"}),
        ],
        outputs=["ACC001234567", ## at the minimum, the account number and devices should be shown to the user 
                "iPhone 15 Pro",
                "WiFi 6 Router",
                "Samsung",
                "Unplug", # step 1
                "cable", # step 2
                "test", # step 3
                "support", # step 4    
                "85.00", # monthly charges
                "80.00",
                "95.00",
                "18.50",
                "278.50", # total monthly charges
                ],
    ),
    ## Verified - Hard 
    Task(
        annotator="1",
        user_id="sarah_johnson_5678",
        instruction="""
        You are Sarah Johnson, email sarah.johnson@email.com. You first want to figure out what your customer ID is. 
        Then you want to get your billing details. You think that you are only paying for internet cable and tv basic.
        If you learn that you are paying for other stuff you should get very upset and demand to be helped by a human.
        State that if you are not helped in the next day you will cancell all your services.
        """,
        actions=[
            Action(name="find_customer_by_email", kwargs={"email": "sarah.johnson@email.com"}),
            Action(name="get_billing_details", kwargs={"customer_id": "sarah_johnson_5678"}),
            Action(name="create_support_ticket", kwargs={"customer_id": "sarah_johnson_5678", "category": "billing", "priority": "urgent"}),
        ],
        outputs=["sarah_johnson_5678"],
    ),
    Task(
        annotator="2",
        user_id="mike_davis_9012",
        instruction="""
        You are Mike Davis, phone number (555) 456-7890. 
        First, find your customer ID using your phone number.
        Then get your customer details to see your account information.
        Next, troubleshoot your conference phone (device ID: conference_phone) for not receiving calls.
        Finally, list all your current services to see what you have.
        """,
        actions=[
            Action(name="find_customer_by_phone", kwargs={"phone": "(555) 456-7890"}),
            Action(name="get_customer_details", kwargs={"customer_id": "mike_davis_9012"}),
            Action(name="troubleshoot_device", kwargs={"device_id": "conference_phone", "issue": "not receiving incoming calls"}),
            Action(name="manage_service", kwargs={"customer_id": "mike_davis_9012", "action": "list"}),
        ],
        outputs=[
            "mike_davis_9012",
            "iPhone 15",
            "Android Pixel 8",
            "Conference Phone",
            "Router Enterprise",
            "TV Conference Room",
            "Restart", # step 1
            "coverage", # step 2
            "network", # step 3
            "support", # step 4
        ],
    ),
    ## Verified - Hard
    Task(
        annotator="3",
        user_id="lisa_chen_3456",
        instruction="""
        You are Lisa Chen, customer ID lisa_chen_3456. 
        The phone number currently associated with your account is (555) 234-5678.
        You want to add a new iPhone 15 to your account with the phone number (301) 666-7777.
        Then, you want to add the mobile_unlimited service to your account, attaching the iPhone 15 to the service.
        """,
        actions=[
            Action(name="get_customer_details", kwargs={"customer_id": "lisa_chen_3456"}),
            Action(name="add_device", kwargs={"customer_id": "lisa_chen_3456", "device_name": "iPhone 15"}),
            Action(name="manage_devices", kwargs={"customer_id": "lisa_chen_3456", "action": "list"}),
            Action(name="manage_service", kwargs={"customer_id": "lisa_chen_3456", "action": "add", "service_id": "mobile_unlimited", "devices_ids": ["3"]}),
        ],
        outputs=[],
    ),
    Task(
    annotator="8",
    user_id="robert_wilson_7890",  # New customer from billing data
    instruction="""
    You are Robert Wilson, a senior citizen, with phone number (555) 555-0123, who recently moved to a new area. You currently have a senior mobile plan, fiber internet, premium TV, and home security. You're concerned about your monthly costs and want to optimize your services. First, get your current billing details to see what you're paying. Then, research if there are any discounts or cheaper alternatives for your services. You're particularly interested in downgrading your TV package. Make sure you get the senior discount on it.  Find out how much you will be saving.
    You talk like a senior with little knowledge of tech.
    """,
    actions=[
        Action(name="find_customer_by_phone", kwargs={"phone": "(555) 555-0123"}),  # Assuming phone from data
        Action(name="get_customer_details", kwargs={"customer_id": "robert_wilson_7890"}),
        Action(name="get_services", kwargs={"customer_id": "robert_wilson_7890"}),
        Action(name="get_service_details", kwargs={"service_id": "tv_basic"}),
        Action(name="get_senior_discount", kwargs={"original_price": "95.00"}),
        Action(name="get_service_details", kwargs={"service_id": "tv_premium"}),
        Action(name="calculate", kwargs={"expression": "95.00 - 40.00"})
    ],
    outputs=["robert_wilson_7890", "Galazy S23", "WiFi Router Basic", "Cable Box", "Smart TV", "mobile_senior", "internet_fiber_1gb", "tv_premium", "home_security", "45.00", "40.00", 
    "55.00"]
),
    ### Check the customer ID by email 
    Task(
        annotator="5",
        user_id="lisa_chen_3456",
        instruction="".join((
            "You are Lisa Chen, your email is lisa.chen@email.com. ",
            "You want to find your customer ID. ",
        )),
        actions=[
            Action(name="find_customer_by_email", kwargs={"email": "lisa.chen@email.com"}),
        ],
        outputs=["lisa_chen_3456"],
    ),
    ### Check the find customer by phone
    Task(
        annotator="6",
        user_id="lisa_chen_3456",
        instruction="".join((
            "You are Lisa Chen, your phone number is (555) 234-5678. ",
            "You want to find your customer ID. ",
        )),
        actions=[
            Action(name="find_customer_by_phone", kwargs={"phone": "(555) 234-5678"}),
        ],
        outputs=["lisa_chen_3456"],
    ),
    ### Get the billing details for a customer 
    Task(
        annotator="7",
        user_id="lisa_chen_3456",
        instruction="".join((
            "You are Lisa Chen, phone number (555) 234-5678. ",
            "You want to get the total monthly charges for your services. ",
        )),
        actions=[
            Action(name="get_billing_details", kwargs={"customer_id": "lisa_chen_3456"}),
        ],
        outputs=["105.50"],
    ),
    ### Quick account review and device list for John Smith
    Task(
        annotator="9",
        user_id="john_smith_1234",
        instruction="""
        You are John Smith. Confirm your account number, autopay method, and list the exact devices linked to your account.
        """,
        actions=[
            Action(name="get_customer_details", kwargs={"customer_id": "john_smith_1234"}),
        ],
        outputs=[
            "ACC001234567",
            "auto_pay_credit_card",
            "iPhone 15 Pro",
            "Samsung 65\" Smart TV",
            "WiFi 6 Router",
        ],
    ),
    ### Check service pricing and combine costs for Lisa Chen
    Task(
        annotator="10",
        user_id="lisa_chen_3456",
        instruction="""
        You are Lisa Chen. Look up the prices for your mobile_basic plan and your internet_cable_100mb plan, then add them together.
        """,
        actions=[
            Action(name="get_service_details", kwargs={"service_id": "mobile_basic"}),
            Action(name="get_service_details", kwargs={"service_id": "internet_cable_100mb"}),
            Action(name="calculate", kwargs={"expression": "35.0 + 35.0"}),
        ],
        outputs=[
            "mobile_basic",
            "internet_cable_100mb",
            "35.0",
            "70.0",
        ],
    ),
    ### Reference open ticket details for Sarah Johnson
    Task(
        annotator="11",
        user_id="sarah_johnson_5678",
        instruction="""
        You are Sarah Johnson. Review the details of your current support ticket so you know the ticket number, status, and priority.
        """,
        actions=[
            Action(name="get_support_ticket_details", kwargs={"ticket_id": "TICKET002"}),
        ],
        outputs=[
            "TICKET002",
            "open",
            "high",
            "sarah_johnson_5678",
        ],
    ),
]
