# Investigating Graph Pooling with Magnitude and Spread

## Layout

The project contains the following folders and files:

- `src/edge_dropping_magnitude.py` – implementation of our proposed magnitude-based edge collapse pooling method, **MagEdgePool** and our proposed spread-based edge collapse pooling method, **SpreadEdgePool**.
- `src/modules/compare_graphs.py` and `src/modules/compare_graph_magnitude.py` – magnitude computations for graphs.
- `src/modules/` – further helper functions for our experiments.
- `src/models/` – the GNNs used for our experiments.
- `src/layers/` – implementations of GNN layers.
- `src/graph_classification/` – our graph classification experiments.
- `src/autoencoder/` – the node feature reconstruction experiment.
- `src/spectral_similarity/` – used to construct the overview in Figure 1.
- `notebooks/` – used to create the plots and tables reported in the main paper based on the files created by running the experiments.

## Dependencies

The required dependencies are specified in the `pyproject.toml` file and are managed using [Poetry](https://python-poetry.org/). Install them by running:

```bash
poetry install
```

Ensure that matching versions of `torch_geometric`, `torch-sparse`, and `torch-scatter` are installed. You can use the `pypoet` tasks for this.

Activate the environment with:

```bash
source $(poetry env info --path)/bin/activate
```

## Reproducing the Results

### Overview of Pooling Methods (Figure 1 and Figure 7)

First, run:

```bash
./src/spectral_similarity/submit_all.sh
```

Then, recreate the overview plot in Figure 1 and the heatmaps in Figure 7 using:

```bash
./notebooks/pooled_graphs_overview.ipynb
```

### ENZYME Graph Example (Figure 2)

Run the notebook:

```bash
./notebooks/overview_enzyme_graph.ipynb
```

to reproduce the plot.

### Graph Classification Results (Table 1 and Table 5)

Run the graph classification benchmark via:

```bash
./src/graph_classification/submit_all.sh
```

Adjust the dataset specified in this script as needed.

Once outputs for each dataset have been created, summarise the experimental results by running:

```bash
poetry run python ./src/graph_classification/jsons_to_csvs.py --path "./results/"
```

from the `./src/graph_classification/` directory.

Then, use the notebook:

```bash
./notebooks/classification_table.ipynb
```

to reproduce the tables reported in the paper.

### Structure Preservation, Classification Accuracy, and Pooling Ratios (Figure 3, Figure 4, and Figure 8)

Recreate the results for varying pooling ratios by running:

```bash
./src/graph_classification/submit_ratio.sh
```

Adjust the submit script as needed.

The plots can be recreated using:

```bash
./notebooks/pooling_ratio.ipynb
```

### Extended Results (Figure 5 and Figure 6)
The magnitude vs. spread plots can be recreated using 

```bash 
./notebooks/pooling_ratio.ipynb
```

The runtime comparison can be summarised using 

```bash 
./notebooks/runtimes_classification.ipynb
```

### Autoencoder Experiment (Table 4)

Run the feature reconstruction experiment via:

```bash
./src/autoencoder/submit_ae.sh
```

Create the table using:

```bash
./notebooks/autoencoder_results.ipynb
```