#!/bin/bash

source $(poetry env info --path)/bin/activate

python run_mincut.py --dataset $1 --runs 10 --batch-size 32 --model "GNN"
python run_diffpool.py --dataset $1 --runs 10 --batch-size 32 --model "GNN"

python run_flat.py --dataset $1 --runs 10 --batch-size 32 --model "GNN"

python run_graclus.py --dataset $1 --runs 10 --batch-size 32 --model "GNN"
python run_ndp.py --dataset $1 --runs 10 --batch-size 32 --model "GNN"
python run_nmf.py --dataset $1 --runs 10 --batch-size 32 --model "GNN"

python run_topk.py --dataset $1 --runs 10 --batch-size 32 --model "GNN"
python run_sagpool.py --dataset $1 --runs 10 --batch-size 32 --model "GNN"

python run_mag_pool_edge.py --dataset $1 --metric "diffusion_distance" --runs 10 --batch-size 32 --mag_method "cholesky" --model "GNN"
python run_mag_pool_edge.py --dataset $1 --metric "diffusion_distance" --runs 10 --batch-size 32 --mag_method "spread" --model "GNN"