
library(parallel)
library(MASS)
library(fda)
library(e1071)
library(refund)
library(VGAM)

#### function ----
dgp<-function(n,sclass=0,alpha=0.1,xnb=50,int_nt=1000){
  
  for(ci in 1:5){
    zeta_phi<-matrix(unlist(lapply(1:int_nt,function(i) #xnb: num of basis of x
      c(1,sqrt(2)*cos((1:(xnb-1))*pi*i/int_nt)))),ncol=int_nt) #dim: xnb*int_nt
    x<-matrix(runif(n*xnb,-sqrt(3),sqrt(3)),ncol=xnb)%*%(zeta_phi * ((-1)^((1:xnb)+1)*(1:xnb)^(-1)) ) #dim: n*xnb %*% xnb*int_nt
    
    if(sclass==0){
      beta<-as.vector( (4*(-1)^((1:xnb)+1)*(1:xnb)^(-2)) %*% zeta_phi)
    }else if(sclass==1){
      beta<-as.vector( ( (runif(xnb,2,8)) *(-1)^((1:xnb)+1)*(1:xnb)^(-2)) %*% zeta_phi)
    }else if(sclass==3){
      beta<-as.vector( ( (runif(xnb,-8,-2)) *(-1)^((1:xnb)+1)*(1:xnb)^(-2)) %*% zeta_phi)
    }else{
      rho<-exp(-15/int_nt);rho1<-sqrt(1-rho^2)
      z<-rnorm(1+int_nt,0,1);beta<-c(z[1],rep(0,int_nt))
      for(i in 1:int_nt){beta[i+1]<-rho*beta[i]+rho1*z[i+1]}
      beta<-beta[-1]
    }
    fx<-as.vector(alpha+x%*%beta/int_nt)
    y<-rbinom(n,1,exp(fx)/(1+exp(fx)));y[which(y==0)]<--1
    xobs<-x[,as.integer((1:nti)*(int_nt/nti))]
    
    if(sd(y)!=0){break}
  }
  return(list('y'=y,'x'=xobs))
}
dpfun<-function(d0,q=0.9,dx=0.01,pri=0,nol=0){
  n<-length(d0$y)
  if(pri){q0<-min(1-q,q-0.5,pri);q<-runif(n,q-q0,q+q0)}
  y1<-d0$y*(rbinom(n,1,q)*2-1)
  
  beta<-mat%*%t(d0$x)
  if(nol && nbasis!=1){
    if(nol==1){beta<-apply(beta,MARGIN=2,function(x) x/max(abs(x)))}else{
      beta<-tanh(beta)}}
  if(nbasis==1){beta<-matrix(beta,nrow=1);if(nol){beta<-tanh(beta)}}
  if(dx>0){beta<-beta+matrix(rlaplace(length(beta),0,dx),nrow=nrow(beta))}
  x1<-t(basismat%*%beta)
  return(list('y'=y1,'x'=x1,'beta'=t(beta)))
}
dwdfun<-function(d0,dtest,qi=0.1,lami=0.01,addcoef=NA,maxi=100,mini=1e-5,lammin=1e-5){#,nx=NA
  #maxi:maximum #iteration; mini:threshold of stop iteration; lammin:minmum eigenvalue selected
  x<-d0$x;y<-d0$y
  nti<-ncol(x);N<-2;
  if(is.na(addcoef[[1]])){add0<-0}else{add0<-as.vector(x%*%addcoef$beta/nti)}
  psi1<-rep(1,nti);psi2<-(0:nti)/nti-0.5
  k2<-((psi2^2-1/12)/2)[-1];k4<-((psi2^4-psi2^2/2+7/240)/24)[-(nti+1)]
  k4st<-matrix(NA,ncol=nti,nrow=nti)
  for(i in 1:nti){k4st[i,i:nti]<-k4st[i:nti,i]<-k4[1:(nti-i+1)]}
  kst<-k2%*%t(k2)-k4st;rm(i,k2,k4,k4st) #nti*nti
  R0<-x%*%kst%*%t(x)/nti^2 #n*n, inner_prod
  S0<-x%*%cbind(psi1,psi2[-1])/nti #n*N, inner_prod
  
  ## for given q and lambda, qi and lami
  R<-R0;S<-S0;n<-nrow(x);theta<-rep(0,1+N+n)
  R_svd<-svd(R);k0<-sum(R_svd$d>lammin)
  B<-cbind(c(n,colSums(S)),rbind(colSums(S),t(S)%*%S))
  C<-cbind(colSums(R),R%*%S)
  Binv<-ginv(B)
  CBinv<-C%*%Binv
  if(is.na(addcoef[[1]])){addi=0}else{addi<-as.vector(addcoef$alpha+add0)}
  
  Pi<-(R_svd$d[1:k0])^2+(R_svd$d[1:k0])*2*n*qi*lami/(qi+1)^2
  Dinv<-R_svd$u[,1:k0]%*%diag(1/Pi,nrow=length(Pi),ncol=length(Pi))%*%t(R_svd$v[,1:k0])
  DinvC<-Dinv%*%C
  P<-Dinv+DinvC%*%ginv(B-t(C)%*%DinvC)%*%t(DinvC);PCBinv<-P%*%CBinv
  Ainv<-cbind(rbind(Binv+t(CBinv)%*%PCBinv,-PCBinv),rbind(-t(PCBinv),P))
  # iteration of theta
  for(i in 1:maxi){
    u<-as.vector(y*(cbind(rep(1,n),S,R)%*%theta+addi));u0<-which(u>qi/(1+qi))
    d1loss<-rep(-1,length(u))
    if(length(u0)>0){d1loss[u0]<- -(qi/u[u0]/(qi+1))^(qi+1)}
    r<-y*d1loss/n;rm(u,u0,d1loss)
    d1theta<-c(sum(r),t(S)%*%r,R%*%r+2*lami*R%*%theta[-(1:(1+N))])
    theta1<-as.vector(theta-n*qi/(qi+1)^2*Ainv%*%d1theta)
    if(mean((theta1-theta)^2)<=mini){break}else{theta<-theta1}
  }
  # the misclassification probability
  hat_alpha<-theta1[1]
  hat_beta<-as.vector(cbind(psi1,psi2[-1])%*%theta1[2:(1+N)]+kst%*%t(x)%*%theta1[-(1:(1+N))])
  test<-mean(((as.vector(hat_alpha+dtest$x%*%hat_beta/nti)>0)*2-1)!=dtest$y)
  
  return(list('beta'=c(hat_alpha,hat_beta),'acc'=test))
}
cgfun<-function(d0,dtest,di=5){
  x<-t(d0$x[which(d0$y==1),]);y<-t(d0$x[which(d0$y==-1),])
  n1<-ncol(x);n2<-ncol(y)
  mu1<-rowMeans(x);mu2<-rowMeans(y);mu<-mu1-mu2;mu12<-(n1*mu1+n2*mu2)/(n1+n2)
  hatk<-((x-mu1)%*%t(x-mu1)+(y-mu2)%*%t(y-mu2))/(n1+n2-2)
  rec<-list()
  phi<-0;v<-z<-mu
  for(i in 1:di){
    h<-as.numeric(sum(v*z)/t(v)%*%hatk%*%v)
    phi<-phi+h*v
    z<-mu-as.vector(hatk%*%phi)
    rec[[i]]<-phi
    g<-as.numeric((t(z)%*%hatk%*%v)/(t(v)%*%hatk%*%v))
    v<-z-g*v
  }
  recg<-matrix(unlist(rec),ncol=di)
  ypre<-apply((dtest$x%*%recg>0)*2-1,MARGIN=2,function(ydi)mean(dtest$y!=ydi))
  return(list('beta'=rbind(rep(0,di),recg),'acc'=ypre))
}
vecfun <- function(d0, dtest){
  logistic_model <- glm(y ~ ., data = data.frame(x = d0$x, y = d0$y), family = "binomial")
  beta_logistic <- coef(logistic_model)
  svm_model <- svm(x = d0$x, y = d0$y, kernel = "linear", probability = TRUE)
  beta_svm <- coef(svm_model)
  beta <- cbind(c(beta_logistic[1],basismat%*%beta_logistic[-1]),
                c(beta_svm[1],basismat%*%beta_svm[-1]))
  acc<-unlist(lapply(1:ncol(beta),function(i)
    mean(((as.vector(beta[1,i]+dtest$x%*%beta[-1,i]/nti)>0)*2-1)!=dtest$y)))
  
  return(list('beta' = beta, 'acc' = acc)) #acc,c(a0,a1)
}
accfun<-function(davgj,betaj,da){
  acc<-apply(betaj,MARGIN=2,function(coefi)
    as.numeric(((as.vector(coefi[1]+davgj$x%*%coefi[-1]/nti)>0)*2-1)!=davgj$y) )
  dam<-matrix(rbinom(length(acc),1,da),nrow=nrow(acc))
  acc1<-acc;acc1[which(dam==0)]<-1-acc1[which(dam==0)]
  acc<-colMeans(acc);acc1<-colMeans(acc1)
  acc2<-sapply((acc1+da-1)/(2*da-1),function(x) median(c(0,1,x)))
  acc<-cbind(acc,acc1,acc2)
  return(acc)
}
aggfun<-function(acck,betak,dtest){
  
  res<-apply(acck,MARGIN=1,function(acc){
    acc<-0.5-acc #larger is better, abs() larger is also better
    resi<-lapply(cutoff,function(p0){
      inx<-which(abs(acc)>(0.5-p0))
      acci<-acc[inx];hati<-t(t(betak[,inx])*sign(acci)) #change sign
      
      if(length(inx)==0){return(list('coef'=rep(NA,51),'acc'=NA))}else{
        hatw<-abs(acci)/sum(abs(acci))
        coef<-as.vector(hati%*%hatw)
        acc<-mean(((as.vector(coef[1]+dtest$x%*%coef[-1]/nti)>0)*2-1)!=dtest$y)
        return(list('coef'=coef,'acc'=acc))}
    })
    coef<-matrix(do.call(c,lapply(resi,function(x) x$coef)),ncol=length(cutoff))
    acc<-unlist(lapply(resi,function(x) x$acc))
    return(list('beta'=coef,'acc'=acc))
  })
  beta<-array(NA,dim=c(dim(res[[1]]$beta),length(res)))
  for(ci in 1:length(res)){beta[,,ci]<-res[[ci]]$beta}
  acc<-matrix(unlist(lapply(res,function(x) x$acc)),ncol=length(res))
  return(list('beta'=beta,'acc'=acc))
}
spld<-function(data,k0){
  n<-length(data$y)
  a<-as.integer(seq(0,n,length.out=k0+1))
  d1<-lapply(1:k0,function(k){
    inx<-(a[k]+1):a[k+1]
    return(list('y'=data$y[inx],'x'=data$x[inx,]))
  })
  return(d1)
}

#### sim ----
## parameters
nti<-50;ti<-(1:nti)/nti
nbasis<-4
order<-min(nbasis,4)
knots<-seq(0,1,1/(nbasis-order+1))
basis<-create.bspline.basis(c(0,1),nbasis,order,knots)
basismat<-eval.basis(ti,basis)
mat<-ginv(t(basismat)%*%basismat)%*%t(basismat)#p*p
rm(order,knots,basis)
cutoff<-seq(0,0.5,length.out=5+1)[-1]

cases<-'bothxy'
edpxy<-c(0.1,0.5,1:5,10)
if(cases=='onlyy'){
  edpy<-edpxy;dy_all<-exp(edpy)/(1+exp(edpy));dx_all<-rep(0,length(edpxy))}else if(cases=='onlyx'){
  edpx<-edpxy;dx_all<-2*nbasis/edpx;dy<-rep(1,length(edpxy))}else{
    edpy<-edpxy/(nbasis+1);dy_all<-exp(edpy)/(1+exp(edpy));dx_all<-2*(nbasis+1)/edpxy}
edpa<-exp(edpxy)/(1+exp(edpxy))
edpa1<-exp(edpxy/2)/(1+exp(edpxy/2))

N<-500;n0<-50;n1<-50;ntest<-500;J<-50
K<-25;cli<-c(rep(1,10),rep(2,5),rep(3,10))

myres<-list()
for(j in 1:length(edpxy)){
  
  dx<-dx_all[j];dy<-dy_all[j];da<-edpa[j];da1<-edpa1[j]
  
  set.seed(7777)
  iseed<-sample(1000:10000,500,replace=F)
  cl<-makeCluster(25,type="FORK")
  myres[[j]]<-parLapply(cl,1:500,function(i){
    tryCatch({
      set.seed(iseed[i])
      alldata<-lapply(1:K,function(k){
        dtest<-dgp(ntest,sclass=cli[k]);dtrain<-dgp(N,sclass=cli[k])
        davg<-lapply(1:J,function(i)dgp(n1,sclass=cli[k]))
        mi=2;dt1<-dpfun(dtrain,q=dy,dx=dx,nol=mi)
        dk<-list(dtest,dtrain,davg,dt1);names(dk)<-c('dtest','dtrain','davg','dt1')
        return(dk)
      })
      
      single<-lapply(1:K,function(k){
        dtest<-alldata[[k]]$dtest;davg<-alldata[[k]]$davg;dt1<-alldata[[k]]$dt1
        
        models<-lapply(1:J,function(jj){
          inx<-sample(N,n0,replace=F)
          d1<-list('y'=dt1$y[inx],'x'=dt1$x[inx,],'beta'=dt1$beta[inx,])
          res1<-vecfun(list('y'=(d1$y+1)/2,'x'=d1$beta),dtest) #logistic, svm
          res2<-dwdfun(d1,dtest);res3<-cgfun(d1,dtest)
          beta<-cbind(res1$beta,res2$beta,res3$beta)
          acc<-c(res1$acc,res2$acc,res3$acc)
          acc1<-accfun(davg[[jj]],beta,da);acc2<-accfun(davg[[jj]],beta,da1)
          acc<-cbind('test'=acc,acc1,acc2)
          return(list('beta'=beta,'acc'=acc))
        })
        beta<-array(NA,dim=c(dim(models[[1]]$beta),J))
        for(ci in 1:J){beta[,,ci]<-models[[ci]]$beta}
        acc<-array(NA,dim=c(dim(models[[1]]$acc),J))
        for(ci in 1:J){acc[,,ci]<-models[[ci]]$acc}
        
        acci<-lapply(1:8,function(k)aggfun(acc[k,,],beta[,k,],dtest))
        acc_avg<-array(NA,dim=c(dim(acci[[1]]$acc),length(acci)))
        for(ci in 1:length(acci)){acc_avg[,,ci]<-acci[[ci]]$acc}
        dimnames(acc_avg)<-list(cutoff,c('test',paste(c('avg','err','crc'),rep(1:2,c(3,3)),sep='_')),
                                c('logi','svm','dwd',paste0('cg',1:5)))
        beta_avg<-array(NA,dim=c(dim(acci[[1]]$beta),length(acci)))
        for(ci in 1:length(acci)){beta_avg[,,,ci]<-acci[[ci]]$beta}
        
        return(list('beta'=beta_avg,'acc'=acc_avg))
      })
      beta1<-array(NA,dim=c(dim(single[[1]]$beta),K))
      for(ci in 1:K){beta1[,,,,ci]<-single[[ci]]$beta}
      acc_avg<-array(NA,dim=c(dim(single[[1]]$acc),K))
      for(ci in 1:K){acc_avg[,,,ci]<-single[[ci]]$acc}
      
      acc_fl<-lapply(1:K,function(k){
        davgk<-list('y'=do.call(c,lapply(alldata[[k]]$davg,function(dk) dk$y)),
                    'x'=do.call(rbind,lapply(alldata[[k]]$davg,function(dk) dk$x)))
        dtest<-alldata[[k]]$dtest
        
        res<-apply(beta1,MARGIN=2:4,function(beta){
          inx<-which(colSums(is.na(beta))==0)
          if(length(inx)==0){accfl<-matrix(NA,nrow=length(cutoff),ncol=3)}else{
            beta<-as.matrix(beta[,inx])
            davgi<-spld(davgk,k0=length(inx))
            acci<-matrix(unlist(lapply(1:length(inx),function(i0){
              return(accfun(davgi[[i0]],as.matrix(beta[,i0]),da1))
            })),ncol=length(inx))
            accfl<-aggfun(acci,beta,dtest)$acc
          }
          return(accfl)
        })
        return(res)
      })
      
      return(list(acc_avg,acc_fl))
    },error=function(e){cat("ERROR : i = ",i,", ",conditionMessage(e), "\n")})
  })
  stopCluster(cl)
  print(j)
  save.image("multi_server.Rdata")
}
save.image("multi_server.Rdata")

