import argparse

datasets_info = [
    'Wisconsin',
    'Texas',
    'Cornell',
    'Chameleon',
    'Squirrel',
    'Film',
    'Cora',
    'CiteSeer',
    'PubMed',
]

def get_args():
    parser = argparse.ArgumentParser(description="Hyperparameter Configuration")

    parser.add_argument(
        "--learning_rates",
        type=float,
        nargs="+",
        default=[1e-1, 1e-2],
        help="List of learning rates"
    )
    parser.add_argument(
        "--weight_decays",
        type=float,
        nargs="+",
        default=[1e-3, 1e-4, 1e-5, 1e-6, 1e-7],
        help="List of weight decay values"
    )
    parser.add_argument(
        "--hidden_dims",
        type=int,
        nargs="+",
        default=[8, 16, 32, 64],
        help="List of hidden dimensions"
    )
    parser.add_argument(
        "--hidden_layers_list",
        type=int,
        nargs="+",
        default=[3, 5, 7],
        help="List of hidden layer counts"
    )
    parser.add_argument(
        "--dropout_rates",
        type=float,
        nargs="+",
        default=[0.0, 0.1, 0.2, 0.4],
        help="List of dropout rates"
    )
    parser.add_argument(
        "--attention_head",
        type=int,
        default=4,
        help="Number of attention heads"
    )
    parser.add_argument(
        "--learning_iterations",
        type=int,
        default=300,
        help="Number of iterations"
    )
    parser.add_argument(
        "--monte_carlo_iteration",
        type=int,
        default=10,
        help="Number of Monte Carlo iterations"
    )
    parser.add_argument(
        "--Time",
        type=int,
        nargs="+",
        default=[1],
        help="Time parameter (list)"
    )
    parser.add_argument(
        "--patience",
        type=int,
        default=30,
        help="Early stopping patience"
    )
    parser.add_argument(
        "--datasets",
        type=str,
        nargs="+",
        choices=datasets_info,
        default=["Cora"],
        help="List of datasets to use"
    )
    return parser.parse_args()


if __name__ == "__main__":
    args = get_args()
    print(args)
