pretrained_models = [
"ResNet18_Weights.IMAGENET1K_V1",
"EfficientNet_B0_Weights.IMAGENET1K_V1",
"GoogLeNet_Weights.IMAGENET1K_V1",
"Swin_T_Weights.IMAGENET1K_V1",
"MobileNet_V3_Large_Weights.IMAGENET1K_V1",
"MobileNet_V3_Large_Weights.IMAGENET1K_V2",
"MobileNet_V3_Small_Weights.IMAGENET1K_V1",
"MNASNet0_5_Weights.IMAGENET1K_V1",
"ShuffleNet_V2_X0_5_Weights.IMAGENET1K_V1",
"AlexNet_Weights.IMAGENET1K_V1",
"ConvNeXt_Tiny_Weights.IMAGENET1K_V1",
"ConvNeXt_Small_Weights.IMAGENET1K_V1",
"DenseNet121_Weights.IMAGENET1K_V1",
"DenseNet161_Weights.IMAGENET1K_V1",
"DenseNet169_Weights.IMAGENET1K_V1",
"DenseNet201_Weights.IMAGENET1K_V1",
"EfficientNet_B1_Weights.IMAGENET1K_V1",
"EfficientNet_B2_Weights.IMAGENET1K_V1",
"EfficientNet_B3_Weights.IMAGENET1K_V1",
"EfficientNet_B4_Weights.IMAGENET1K_V1",
"EfficientNet_V2_S_Weights.IMAGENET1K_V1",
"Inception_V3_Weights.IMAGENET1K_V1",
"MNASNet0_75_Weights.IMAGENET1K_V1",
"MNASNet1_0_Weights.IMAGENET1K_V1",
"MNASNet1_3_Weights.IMAGENET1K_V1",
"MaxVit_T_Weights.IMAGENET1K_V1",
"MobileNet_V2_Weights.IMAGENET1K_V1",
"MobileNet_V2_Weights.IMAGENET1K_V2",
"RegNet_X_1_6GF_Weights.IMAGENET1K_V1",
"RegNet_X_1_6GF_Weights.IMAGENET1K_V2",
"RegNet_X_3_2GF_Weights.IMAGENET1K_V1",
"RegNet_X_3_2GF_Weights.IMAGENET1K_V2",
"RegNet_X_400MF_Weights.IMAGENET1K_V1",
"RegNet_X_400MF_Weights.IMAGENET1K_V2",
"RegNet_X_800MF_Weights.IMAGENET1K_V1",
"RegNet_X_800MF_Weights.IMAGENET1K_V2",
"RegNet_Y_1_6GF_Weights.IMAGENET1K_V1",
"RegNet_Y_1_6GF_Weights.IMAGENET1K_V2",
"RegNet_Y_3_2GF_Weights.IMAGENET1K_V1",
"RegNet_Y_3_2GF_Weights.IMAGENET1K_V2",
"RegNet_Y_400MF_Weights.IMAGENET1K_V1",
"RegNet_Y_400MF_Weights.IMAGENET1K_V2",
"RegNet_Y_800MF_Weights.IMAGENET1K_V1",
"RegNet_Y_800MF_Weights.IMAGENET1K_V2",
"ResNeXt50_32X4D_Weights.IMAGENET1K_V1",
"ResNeXt50_32X4D_Weights.IMAGENET1K_V2",
"ResNet101_Weights.IMAGENET1K_V1",
"ResNet101_Weights.IMAGENET1K_V2",
"ResNet50_Weights.IMAGENET1K_V1",
"ResNet50_Weights.IMAGENET1K_V2",
"ResNet34_Weights.IMAGENET1K_V1",
"ShuffleNet_V2_X1_0_Weights.IMAGENET1K_V1",
"ShuffleNet_V2_X1_5_Weights.IMAGENET1K_V1",
"ShuffleNet_V2_X2_0_Weights.IMAGENET1K_V1",
"Swin_V2_T_Weights.IMAGENET1K_V1",
"ViT_B_32_Weights.IMAGENET1K_V1",
"ViT_B_16_Weights.IMAGENET1K_V1",
"ViT_B_16_Weights.IMAGENET1K_SWAG_LINEAR_V1",
"Wide_ResNet50_2_Weights.IMAGENET1K_V1",
"Wide_ResNet50_2_Weights.IMAGENET1K_V2",
]

timm_pretrained_models = [
"timm.mobileone_s0",
"timm.mobileone_s1",
"timm.mobileone_s2",
"timm.mobileone_s3",
"timm.mobileone_s4",
"timm.inception_next_tiny.sail_in1k",
"timm.inception_next_small.sail_in1k",
"timm.inception_next_base.sail_in1k",
"timm.ghostnet_100.in1k",
"timm.ghostnetv2_100.in1k",
"timm.ghostnetv2_130.in1k",
"timm.ghostnetv2_160.in1k",
"timm.repghostnet_050.in1k",
"timm.repghostnet_058.in1k",
"timm.repghostnet_080.in1k",
"timm.repghostnet_100.in1k",
"timm.efficientvit_b0.r224_in1k",
"timm.efficientvit_b1.r224_in1k",
"timm.efficientvit_b2.r224_in1k",
"timm.efficientvit_b3.r224_in1k",
"timm.efficientvit_m0.r224_in1k",
"timm.efficientvit_m1.r224_in1k",
"timm.efficientvit_m2.r224_in1k",
"timm.efficientvit_m3.r224_in1k",
"timm.efficientvit_m4.r224_in1k",
"timm.efficientvit_m5.r224_in1k",
"timm.coatnet_nano_rw_224.sw_in1k",
"timm.coatnext_nano_rw_224.sw_in1k",
"timm.seresnext101_32x4d.gluon_in1k",
"timm.vit_tiny_r_s16_p8_224.augreg_in21k",
"timm.vit_small_r26_s32_224.augreg_in21k",
"timm.vit_tiny_r_s16_p8_224.augreg_in21k_ft_in1k",
"timm.vit_small_r26_s32_224.augreg_in21k_ft_in1k",
"timm.hrnet_w18_small.gluon_in1k",
"timm.hrnet_w18_small_v2.gluon_in1k",
"timm.vit_small_patch16_224.dino",
"timm.vit_base_patch16_224.mae",
"timm.maxvit_tiny_tf_224.in1k",
"timm.maxvit_tiny_rw_224.sw_in1k",
"timm.vit_base_patch32_224.sam_in1k",
"timm.vit_base_patch32_clip_224.openai_ft_in1k",
]



def bash_gen(fout, base_cmd, pretrained_models, key = '*',):
    with open(fout, 'w') as f:
        print ('#!/bin/bash', file=f)
        for i, pretrained_model in enumerate(pretrained_models):
            print ('# %d %s'%(i+1,pretrained_model), file=f)
            print (base_cmd.replace(key, pretrained_model), file=f)

base_cmd = "python3 upstream_preparation.py --name=FeatureWeighting+resnet18_pretrained_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.01 --surrogate_type=FeatureWeighting+resnet18_pretrained --fix_backbone --min_sim --steps=20000 --step_size=5000 --overwrite"

bash_gen('./bash/embedding_resnet18.sh', base_cmd, pretrained_models)

base_cmd2 = "python3 upstream_preparation.py --name=FeatureWeighting+Swin_T_pretrained_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.01 --surrogate_type=FeatureWeighting+Swin_T_pretrained --fix_backbone --min_sim --steps=20000 --step_size=5000 --overwrite"

bash_gen('./bash/embedding_swin_t.sh', base_cmd2, pretrained_models)

base_cmd3 = "python3 upstream_preparation.py --name=FeatureWeighting+resnet18_pretrained_10k_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.01 --surrogate_type=FeatureWeighting+resnet18_pretrained --fix_backbone --min_sim --steps=10000 --step_size=3000 --overwrite"

bash_gen('./bash/embedding_resnet18_10k.sh', base_cmd3, pretrained_models)

base_cmd4 = "python3 upstream_preparation.py --name=FeatureWeighting+Swin_T_pretrained_10k_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.01 --surrogate_type=FeatureWeighting+Swin_T_pretrained --fix_backbone --min_sim --steps=10000 --step_size=3000 --overwrite"

bash_gen('./bash/embedding_swin_t_10k.sh', base_cmd4, pretrained_models)

base_cmd5 = "python3 downstream_selection.py --name=eval_CIFAR10_* --dataset_train=CIFAR10-std_train --dataset_val=CIFAR10_val --n_class=10 --evaluation --model=* --overwrite --epochs=60 --step_size=15 --weight_decay=5e-4"
bash_gen('./bash/eval_CIFAR10.sh', base_cmd5, pretrained_models)

base_cmd6 = "python3 downstream_selection.py --name=eval_CIFAR100_* --dataset_train=CIFAR100-std_train --dataset_val=CIFAR100_val --n_class=100 --evaluation --model=* --overwrite --epochs=60 --step_size=15 --weight_decay=5e-4"
bash_gen('./bash/eval_CIFAR100.sh', base_cmd6, pretrained_models)


base_cmd7 = "python3 downstream_selection.py --name=eval_STL10_* --dataset_train=STL10-std_train --dataset_val=STL10_test --n_class=10 --evaluation --model=* --overwrite --epochs=60 --step_size=15 --weight_decay=5e-4"
bash_gen('./bash/eval_STL10.sh', base_cmd7, pretrained_models)





##4000steps

base_cmd = "python3 upstream_preparation.py --name=FeatureWeighting+resnet18_pretrained_4k_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.01 --surrogate_type=FeatureWeighting+resnet18_pretrained --fix_backbone --min_sim --steps=4000 --step_size=1000 --overwrite"

bash_gen('./bash/embedding_resnet18_4k.sh', base_cmd, pretrained_models)

base_cmd2 = "python3 upstream_preparation.py --name=FeatureWeighting+Swin_T_pretrained_4k_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.01 --surrogate_type=FeatureWeighting+Swin_T_pretrained --fix_backbone --min_sim --steps=4000 --step_size=1000 --overwrite"

bash_gen('./bash/embedding_swin_t_4k.sh', base_cmd2, pretrained_models)


base_cmd = "python3 upstream_preparation.py --name=FeatureWeighting+resnet18_pretrained_4k_temp0.1_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.1 --surrogate_type=FeatureWeighting+resnet18_pretrained --fix_backbone --min_sim --steps=4000 --step_size=1000 --overwrite"

bash_gen('./bash/embedding_resnet18_4k_temp0.1.sh', base_cmd, pretrained_models)

base_cmd2 = "python3 upstream_preparation.py --name=FeatureWeighting+Swin_T_pretrained_4k_temp0.1_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.1 --surrogate_type=FeatureWeighting+Swin_T_pretrained --fix_backbone --min_sim --steps=4000 --step_size=1000 --overwrite"

bash_gen('./bash/embedding_swin_t_4k_temp0.1.sh', base_cmd2, pretrained_models)


##2000steps

base_cmd = "python3 upstream_preparation.py --name=FeatureWeighting+resnet18_pretrained_2k_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.01 --surrogate_type=FeatureWeighting+resnet18_pretrained --fix_backbone --min_sim --steps=2000 --step_size=500 --overwrite"

bash_gen('./bash/embedding_resnet18_2k.sh', base_cmd, pretrained_models)

base_cmd2 = "python3 upstream_preparation.py --name=FeatureWeighting+Swin_T_pretrained_2k_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.01 --surrogate_type=FeatureWeighting+Swin_T_pretrained --fix_backbone --min_sim --steps=2000 --step_size=500 --overwrite"

bash_gen('./bash/embedding_swin_t_2k.sh', base_cmd2, pretrained_models)


base_cmd = "python3 upstream_preparation.py --name=FeatureWeighting+resnet18_pretrained_2k_temp0.1_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.1 --surrogate_type=FeatureWeighting+resnet18_pretrained --fix_backbone --min_sim --steps=2000 --step_size=500 --overwrite"

bash_gen('./bash/embedding_resnet18_2k_temp0.1.sh', base_cmd, pretrained_models)

base_cmd2 = "python3 upstream_preparation.py --name=FeatureWeighting+Swin_T_pretrained_2k_temp0.1_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.1 --surrogate_type=FeatureWeighting+Swin_T_pretrained --fix_backbone --min_sim --steps=2000 --step_size=500 --overwrite"

bash_gen('./bash/embedding_swin_t_2k_temp0.1.sh', base_cmd2, pretrained_models)


##4000steps count time

base_cmd = "python3 upstream_preparation.py --name=FeatureWeighting+resnet18_pretrained_4k_time_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.01 --surrogate_type=FeatureWeighting+resnet18_pretrained --fix_backbone --min_sim --steps=4000 --step_size=1000 --overwrite"

bash_gen('./bash/embedding_resnet18_4k_time.sh', base_cmd, pretrained_models)

base_cmd2 = "python3 upstream_preparation.py --name=FeatureWeighting+Swin_T_pretrained_4k_time_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.01 --surrogate_type=FeatureWeighting+Swin_T_pretrained --fix_backbone --min_sim --steps=4000 --step_size=1000 --overwrite"

bash_gen('./bash/embedding_swin_t_4k_time.sh', base_cmd2, pretrained_models)


base_cmd = "python3 upstream_preparation.py --name=FeatureWeighting+resnet18_pretrained_4k_temp0.1_time_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.1 --surrogate_type=FeatureWeighting+resnet18_pretrained --fix_backbone --min_sim --steps=4000 --step_size=1000 --overwrite"

bash_gen('./bash/embedding_resnet18_4k_temp0.1_time.sh', base_cmd, pretrained_models)

base_cmd2 = "python3 upstream_preparation.py --name=FeatureWeighting+Swin_T_pretrained_4k_temp0.1_time_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.1 --surrogate_type=FeatureWeighting+Swin_T_pretrained --fix_backbone --min_sim --steps=4000 --step_size=1000 --overwrite"

bash_gen('./bash/embedding_swin_t_4k_temp0.1_time.sh', base_cmd2, pretrained_models)



base_cmd7 = "python3 downstream_selection.py --name=eval_SVHN_* --dataset_train=SVHN-std_train --dataset_val=SVHN_test --n_class=10 --evaluation --model=* --overwrite --epochs=60 --step_size=15 --weight_decay=5e-4"
bash_gen('./bash/eval_SVHN.sh', base_cmd7, pretrained_models)

base_cmd7 = "python3 downstream_selection.py --name=eval_SVHN_* --dataset_train=SVHN_train --dataset_val=SVHN_test --n_class=10 --evaluation --model=* --overwrite --epochs=60 --step_size=15 --weight_decay=5e-4"
bash_gen('./bash/eval_SVHN_no_aug.sh', base_cmd7, pretrained_models)







base_cmd = "python3 upstream_preparation.py --name=FeatureWeighting+resnet18_pretrained_4k_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.01 --surrogate_type=FeatureWeighting+resnet18_pretrained --fix_backbone --min_sim --steps=4000 --step_size=1000 --overwrite"

bash_gen('./bash/timm_embedding_resnet18_4k.sh', base_cmd, timm_pretrained_models)

base_cmd2 = "python3 upstream_preparation.py --name=FeatureWeighting+Swin_T_pretrained_4k_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.01 --surrogate_type=FeatureWeighting+Swin_T_pretrained --fix_backbone --min_sim --steps=4000 --step_size=1000 --overwrite"

bash_gen('./bash/timm_embedding_swin_t_4k.sh', base_cmd2, timm_pretrained_models)


base_cmd3 = "python3 upstream_preparation.py --name=FeatureWeighting+resnet18_pretrained_10k_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.01 --surrogate_type=FeatureWeighting+resnet18_pretrained --fix_backbone --min_sim --steps=10000 --step_size=3000 --overwrite"

bash_gen('./bash/timm_embedding_resnet18_10k.sh', base_cmd3, timm_pretrained_models)

base_cmd4 = "python3 upstream_preparation.py --name=FeatureWeighting+Swin_T_pretrained_10k_* --datasets=ImageNet-std_val --pretrained_models=* --pretrained_datasets=ImageNet-std_val --temperature=0.01 --surrogate_type=FeatureWeighting+Swin_T_pretrained --fix_backbone --min_sim --steps=10000 --step_size=3000 --overwrite"

bash_gen('./bash/timm_embedding_swin_t_10k.sh', base_cmd4, timm_pretrained_models)


base_cmd5 = "python3 downstream_selection.py --name=eval_CIFAR10_* --dataset_train=CIFAR10-std_train --dataset_val=CIFAR10_val --n_class=10 --evaluation --model=* --overwrite --epochs=60 --step_size=15 --weight_decay=5e-4"
bash_gen('./bash/timm_eval_CIFAR10.sh', base_cmd5, timm_pretrained_models)

base_cmd6 = "python3 downstream_selection.py --name=eval_CIFAR100_* --dataset_train=CIFAR100-std_train --dataset_val=CIFAR100_val --n_class=100 --evaluation --model=* --overwrite --epochs=60 --step_size=15 --weight_decay=5e-4"
bash_gen('./bash/timm_eval_CIFAR100.sh', base_cmd6, timm_pretrained_models)

base_cmd7 = "python3 downstream_selection.py --name=eval_STL10_* --dataset_train=STL10-std_train --dataset_val=STL10_test --n_class=10 --evaluation --model=* --overwrite --epochs=60 --step_size=15 --weight_decay=5e-4"
bash_gen('./bash/timm_eval_STL10.sh', base_cmd7, timm_pretrained_models)