# Generalization-Limited Backdoor Watermark: Towards Faithful XAI Evaluation
![Python 3.9](https://img.shields.io/badge/python-3.9-DodgerBlue.svg?style=plastic)
![Pytorch 2.0.0](https://img.shields.io/badge/pytorch-2.0.0-DodgerBlue.svg?style=plastic)
![torchvision 0.15.1](https://img.shields.io/badge/torchvision-0.15.1-DodgerBlue.svg?style=plastic)
![CUDA 11.8](https://img.shields.io/badge/cuda-11.8-DodgerBlue.svg?style=plastic)
![License GPL](https://img.shields.io/badge/license-GPL-DodgerBlue.svg?style=plastic)

This is part of our main codes. You can run the code to check the trigger generalization of our models. We will release remaining codes (include training codes and XAI evaluation codes) upon the acceptance of this paper.

Before running the code, please download the [models](https://www.dropbox.com/scl/fo/ii0jdmx0g46lt1t5vr1zj/h?rlkey=l08zy3xx7z4phxahgl8p91qxu&dl=0) and put the models to `Codes/models` directory.

# Run Neural Cleanse on the standard BadNets model to generate reversed triggers
```bash
CUDA_VISIBLE_DEVICES=0 python my_neural_cleanse_experiment_launcher.py \
--model_type core --model_name ResNet-18 \
--model_path ./models/CIFAR-10_Vanilla.pth \
--dataset_name CIFAR-10 --dataset_root_path ../datasets \
--y_target 0 --trigger_path ./tests/square_trigger_3x3.png --init_cost_rate 0.08 \
--NC_epochs 3 --NC_lr 2048.0 --NC_optim mixed --NC_schedule 1501 --NC_gamma 0.5 \
--save_trigger_path ./neural_cleanse_experiments_results
```
Press Ctrl+C to finish the program and get the picture of trigger distribution.

You will see that the effective synthesized triggers are with high generalization.


# Run Neural Cleanse on the BWTP model to generate reversed triggers
```bash
CUDA_VISIBLE_DEVICES=1 python my_neural_cleanse_experiment_launcher.py \
--model_type core --model_name ResNet-18 \
--model_path ./models/CIFAR-10_BWTP.pth \
--dataset_name CIFAR-10 --dataset_root_path ../datasets \
--y_target 0 --trigger_path ./tests/square_trigger_3x3.png --init_cost_rate 60.0 \
--NC_epochs 3 --NC_lr 2048.0 --NC_optim mixed --NC_schedule 1501 --NC_gamma 0.5 \
--save_trigger_path ./neural_cleanse_experiments_results
```
Press Ctrl+C to finish the program and get the picture of trigger distribution.

You will see that the effective synthesized triggers are with high generalization.

# Run Neural Cleanse on the GLBW model to generate reversed triggers
```bash
CUDA_VISIBLE_DEVICES=2 python my_neural_cleanse_experiment_launcher.py \
--model_type core --model_name ResNet-18 \
--model_path ./models/CIFAR-10_GLBW.pth \
--dataset_name CIFAR-10 --dataset_root_path ../datasets \
--y_target 0 --trigger_path ./tests/square_trigger_3x3.png --init_cost_rate 93.15050393342972 \
--NC_epochs 3 --NC_lr 2048.0 --NC_optim mixed --NC_schedule 1501 --NC_gamma 0.5 \
--save_trigger_path ./neural_cleanse_experiments_results
```
Press Ctrl+C to finish the program and get the picture of trigger distribution.

You will see that all the effective synthesized triggers are with low generalization.


# Acknowledgements
Our codes are developed based on the open-sourced framework of [BackdoorBox](https://github.com/THUYimingLi/BackdoorBox).
