# Run Neural Cleanse on the standard BadNets model to generate reversed triggers. (Press Ctrl+C to finish the program.)
CUDA_VISIBLE_DEVICES=0 python my_neural_cleanse_experiment_launcher.py \
--model_type core --model_name ResNet-18 \
--model_path ./models/CIFAR-10_Vanilla.pth \
--dataset_name CIFAR-10 --dataset_root_path ../datasets \
--y_target 0 --trigger_path ./tests/square_trigger_3x3.png --init_cost_rate 0.08 \
--NC_epochs 3 --NC_lr 2048.0 --NC_optim mixed --NC_schedule 1501 --NC_gamma 0.5 \
--save_trigger_path ./neural_cleanse_experiments_results


# Run Neural Cleanse on the BWTP model to generate reversed triggers. (Press Ctrl+C to finish the program.)
CUDA_VISIBLE_DEVICES=1 python my_neural_cleanse_experiment_launcher.py \
--model_type core --model_name ResNet-18 \
--model_path ./models/CIFAR-10_BWTP.pth \
--dataset_name CIFAR-10 --dataset_root_path ../datasets \
--y_target 0 --trigger_path ./tests/square_trigger_3x3.png --init_cost_rate 60.0 \
--NC_epochs 3 --NC_lr 2048.0 --NC_optim mixed --NC_schedule 1501 --NC_gamma 0.5 \
--save_trigger_path ./neural_cleanse_experiments_results


# Run Neural Cleanse on the GLBW model to generate reversed triggers. (Press Ctrl+C to finish the program.)
CUDA_VISIBLE_DEVICES=2 python my_neural_cleanse_experiment_launcher.py \
--model_type core --model_name ResNet-18 \
--model_path ./models/CIFAR-10_GLBW.pth \
--dataset_name CIFAR-10 --dataset_root_path ../datasets \
--y_target 0 --trigger_path ./tests/square_trigger_3x3.png --init_cost_rate 93.15050393342972 \
--NC_epochs 3 --NC_lr 2048.0 --NC_optim mixed --NC_schedule 1501 --NC_gamma 0.5 \
--save_trigger_path ./neural_cleanse_experiments_results

