(* ::Package:: *)

(* Wolfram Language code to reproduce the results in "A path toward primitive machine intelligence: LMM not LLM is what you need."
Runtime: Less than 2 minutes on a Intel Core-i3 PC *)


syntheticData[N_,R_,M_,T_]:=With[{\[Alpha]=R^(1./(N-1)),\[Beta]=0.1^(12/(M-1))},
Do[(*Pure spectrum*) a[m]=RandomSample[\[Alpha]^(Range[N]-1)],{m,M}];
Table[ Do[(*Chemical concentration*)p[m,t]=RandomReal[\[Beta]^(m-1)],{m,M}];
(*Signal intensity*) s[t]=\!\(
\*SubsuperscriptBox[\(\[Sum]\), \(m = 1\), \(M\)]\(p[m, t] a[m]\)\) ,{t,T}]  ]

(*Eigenvalue analysis of sample covariance matrix*)
plot[N_,R_,M_]:=
Block[{T=(M*N)/(N-M),s},
s=syntheticData[N,R,M,T];
Cov=Covariance[(#/Mean@s&/@s)];
ListLogPlot[ {ReverseSort@Eigenvalues[Covariance[s/Mean@Mean@s]],ReverseSort@Eigenvalues[Cov]},PlotRange->{{0,50},All}]]


(*Figure 4*)
{plot[100,10^10,8],plot[10000,10^10,8],plot[1000,100,8]}


SetDirectory[NotebookDirectory[]];
p=Import["ChemicalConcentrations.csv"];
a=Import["PureSpectra.csv"];
s=Import["Observations.csv"];
(*Maximum estimation error*)
Max@Abs[p-s . PseudoInverse[a]]


ev=Eigenvectors[Covariance[s],8];
{A,S}=ResourceFunction["IndependentComponentAnalysis"][Transpose@s,8];
{W,H}=ResourceFunction["NonNegativeMatrixFactorization"][Transpose@s,8];
(*Figure 5*)
plot[spectra_]:=GraphicsRow[ListLinePlot[#,Joined->True,PlotRange->All,PlotTheme->"Minimal"]&/@spectra]
plot[a]
plot[ev*Sign[Mean/@ev]]
plot[Transpose@A]
plot[Transpose@W]
plot[Transpose@PseudoInverse[a]]
