import sys
sys.path.append("/home/projects/CLIP")
from transformers import GPT2Tokenizer
import os
from custom_types import *
import torch
from gpt2_prefix import ClipCaptionModel, MappingType
from PIL import Image
import matplotlib.pyplot as plt
import json
import clip   # installed from https://github.com/openai/CLIP
import argparse, pickle
from gpt2_prefix_eval import generate_beam, generate2, imshow, get_prefix_tokens
from torchvision import transforms
from sklearn.cluster import KMeans
import numpy as np
import os.path

def count_ready_parphrased_embeddings(embeddings_dict):
    ready = 0
    for img_id in embeddings_dict.keys():
        if embeddings_dict[img_id] is not None:
            if len(embeddings_dict[img_id]) == 5:
                ready += 1
    return ready


def get_precalculated_centers():
    with open('others/CLIP_embeddings_centers_info.pkl', 'rb') as f:
        return pickle.load(f)


def calc_distances_of_ready_embeddings(embeddings_dict, out_file='embeddings_distances.pkl'):
    # calculate the distance between the 5 prefixes
    distances, distances_l2, data_size = [], [], 0
    distances_clip, distances_l2_clip, max_distances_l1, distances_l2_from_center, max_distances_l1_from_center, maxoutof5 = [], [], [], [], [], []
    for img_id in embeddings_dict.keys():
        data_size += 1
        dist, dist_l2, combs, shape_pref = 0.0, 0.0, 0, 0
        dist_clip, dist_l2_clip, shape_pref_clip, max_distance_l1 = 0.0, 0.0, 0.0, 0.0
        distances_between_paraphrased_embeddings = []
        for i in range(len(embeddings_dict[img_id])):
            for j in range(i + 1, len(embeddings_dict[img_id])):
                dist += np.linalg.norm(embeddings_dict[img_id][i][0] -
                                       embeddings_dict[img_id][j][0], ord=1)
                dist_l2 += np.linalg.norm(embeddings_dict[img_id][i][0] -
                                          embeddings_dict[img_id][j][0], ord=2)
                shape_pref = embeddings_dict[img_id][i][0].shape[0]
                combs += 1
                dist_clip += np.linalg.norm(embeddings_dict[img_id][i][1] -
                                            embeddings_dict[img_id][j][1], ord=1)
                dist_l2_clip += np.linalg.norm(embeddings_dict[img_id][i][1] -
                                               embeddings_dict[img_id][j][1], ord=2)
                shape_pref_clip = embeddings_dict[img_id][i][1].shape[0]

                max_distance_l1 += np.abs(embeddings_dict[img_id][i][1] - embeddings_dict[img_id][j][1]).max()
                distances_between_paraphrased_embeddings.append(np.linalg.norm(embeddings_dict[img_id][i][1] -
                                               embeddings_dict[img_id][j][1], ord=2) / (shape_pref_clip ** 0.5))

        if combs == 5 * 4 / 2:
            # todo note that for l2 you should devide by sqrt(dim) rather than dim! for fix use *sqrt(sim)) later
            distances.append(dist / (shape_pref * combs))
            distances_l2.append(dist_l2 / (shape_pref * combs))
            distances_clip.append(dist_clip / (shape_pref_clip * combs))
            distances_l2_clip.append(dist_l2_clip / (shape_pref_clip * combs))
            max_distances_l1.append(max_distance_l1 / combs)
            maxoutof5.append(np.max(distances_between_paraphrased_embeddings))

        # calculate the distance from the center
        five_embeddings = np.array([s[1] for s in embeddings_dict[img_id]])
        center = five_embeddings.mean(axis=0)
        distances_l2_from_center.append(np.linalg.norm(five_embeddings - center, ord=2, axis=1).mean())
        max_distances_l1_from_center.append(np.abs(five_embeddings - center).max(axis=1).mean())
    print(
        f"\n\n\n Average noremlised L1 between 5 annotations of same image MAPPER: {np.array(distances).mean()}, STD: {np.array(distances).std()}")
    print(
        f"\n\n\n Average noremlised L2 between 5 annotations of same image MAPPER: {np.array(distances_l2).mean()}, STD: {np.array(distances_l2).std()}")
    print(
        f"\n\n\n Average noremlised L1 between 5 annotations of same image CLIP: {np.array(distances_clip).mean()}, STD: {np.array(distances_clip).std()}")
    print(
        f"\n\n\n Average noremlised L2 between 5 annotations of same image CLIP: {np.array(distances_l2_clip).mean()}, STD: {np.array(distances_l2_clip).std()}")
    print(
        f"\n\n\n Mean L2 between 5 annotations of same image CLIP to their center: {np.array(distances_l2_from_center).mean()}, STD: {np.array(distances_l2_from_center).std()}")
    print(
        f"\n\n\n Max (per-entry) L1 between 5 annotations of same image CLIP to their center: {np.array(max_distances_l1_from_center).mean()}, STD: {np.array(max_distances_l1_from_center).std()}")
    print(
        f"\n\n\n Max (per-entry) L1 between 5 annotations of same image CLIP: {np.array(max_distances_l1).mean()}, STD: {np.array(max_distances_l1).std()}")
    print(
        f"\n\n\n Taking max out of the 10 L2 between 5 annotations of same image CLIP: {np.array(maxoutof5).mean()}")
    if out_file is not None:
        import pickle
        with open(out_file, 'wb') as f:
            pickle.dump(({"distances_clip": distances_clip, "distances_l2_clip": distances_l2_clip, "max_distances_l1": max_distances_l1}), f)
        print(f"Saved distances to {out_file} and finished")
        exit(0)
    return distances, distances_l2, distances_clip, distances_l2_clip, data_size


def image_to_display(img) -> ARRAY:
    if type(img) is str:
        img = Image.open(str(img))
    if type(img) is not V:
        img = V(img)
    return img


def imshow(img, title: Optional[str] = None):
    img = image_to_display(img)
    plt.imshow(img)
    plt.axis("off")
    if title is not None:
        plt.title(title)
    plt.show()
    plt.close('all')


def clip_transform_full(n_px=224):
    return transforms.Compose([
        transforms.Resize((n_px, n_px), interpolation=Image.BICUBIC),
        lambda image: image.convert("RGB"),
        transforms.ToTensor(),
        transforms.Normalize((0.48145466, 0.4578275, 0.40821073), (0.26862954, 0.26130258, 0.27577711)),
    ])


class Timer:
    """
    measure inference time
    """
    def __init__(self):
        self.sum = 0
        self.count = 0
        self.starter, self.ender = torch.cuda.Event(enable_timing=True), torch.cuda.Event(enable_timing=True)
        self.timings = []

    def __enter__(self):
        self.starter.record()
        return self

    def __exit__(self, *args):
        self.ender.record()
        torch.cuda.synchronize()
        interval = self.starter.elapsed_time(self.ender)
        self.timings.append(interval)
        self.sum += interval
        self.count += 1

    def __str__(self):
        mean_syn = self.sum / self.count
        std_syn = np.std(self.timings)
        return f"mean: {mean_syn:.2f} ms, std: {std_syn:.2f} ms"


def make_preds(model: ClipCaptionModel, out_path, tokenizer, results, given_prefix, args=None):
    device = CUDA(0)
    model = model.to(device)
    model.eval()
    # preprocess = clip_transform_full()
    #prefix_length = 10

    if args.add_modality_offset:
        modality_offset = get_precalculated_centers()['offset_to_add_in_inference'].to(device)

    if args.modality_bridger:
        from others.supervised_embedding_bridger import get_map_to_text_space_using_modality_bridger
        map_to_text_space_using_modality_bridger = get_map_to_text_space_using_modality_bridger()

    embeddings = model.gpt.get_input_embeddings().weight.data   
    embeddings = nnf.normalize(embeddings, 2, 1)  
    new_data = []
    # results = []
    timer = Timer()
    with torch.no_grad():
        timer.__enter__()
             
        #prefix
        prefix = given_prefix           
        if not args.dont_normalize_prefix: 
            prefix = prefix / prefix.norm(2, -1)
        if args.add_modality_offset:
            prefix = prefix + modality_offset
        if args.modality_bridger:
            prefix = map_to_text_space_using_modality_bridger(prefix)
            prefix / prefix.norm(2, -1)
        prefix_embed = model.clip_project(prefix).reshape(1, args.prefix_length, -1) 
    
    if args.beam:
        generated_text_prefix = generate_beam(model, tokenizer, embed=prefix_embed)[0] 
    else:
        generated_text_prefix = generate2(model, tokenizer, embed=prefix_embed)
    timer.__exit__()
    results.append(generated_text_prefix.lower()) 
    # print("'"+generated_text_prefix.lower()+"'"+",")
    
    if DEBUG and not args.ablation_dist and False:
        prefix_sent = get_prefix_tokens(prefix_embed, embeddings, tokenizer)
        imshow(image_raw, title=f'{generated_text_prefix}\n{prefix_sent}')

    new_data.append({"caption": generated_text_prefix.lower()})
    
    return 0


def make_preds_test(model: ClipCaptionModel, out_path, tokenizer, clip_model, args=None):
    device = CUDA(0)
    model = model.to(device)
    model.eval()
    # preprocess = clip_transform_full()
    #prefix_length = 10

    if args.add_modality_offset:
        modality_offset = get_precalculated_centers()['offset_to_add_in_inference'].to(device)

    if args.modality_bridger:
        from others.supervised_embedding_bridger import get_map_to_text_space_using_modality_bridger
        map_to_text_space_using_modality_bridger = get_map_to_text_space_using_modality_bridger()

    embeddings = model.gpt.get_input_embeddings().weight.data   
    embeddings = nnf.normalize(embeddings, 2, 1)  
    new_data = []
    results = []
    timer = Timer()
    
    caption= "Man riding a motor bike on a dirt road on the countryside"
    clip_model = clip_model
    with torch.no_grad():
        timer.__enter__()
        
        caption_tokens = clip.tokenize(caption).to(device)
        prefix = clip_model.encode_text(caption_tokens).float() 
        
        if not args.dont_normalize_prefix: 
            prefix = prefix / prefix.norm(2, -1)
        if args.add_modality_offset:
            prefix = prefix + modality_offset
        if args.modality_bridger:
            prefix = map_to_text_space_using_modality_bridger(prefix)
            prefix / prefix.norm(2, -1)
        prefix_embed = model.clip_project(prefix).reshape(1, args.prefix_length, -1) 
    
    if args.beam:
        generated_text_prefix = generate_beam(model, tokenizer, embed=prefix_embed)[0] 
    else:
        generated_text_prefix = generate2(model, tokenizer, embed=prefix_embed)
    timer.__exit__()
    results.append(generated_text_prefix.lower())
    print(caption)
    print("generated_text_prefix.lower()")
    
    if DEBUG and not args.ablation_dist and False:
        prefix_sent = get_prefix_tokens(prefix_embed, embeddings, tokenizer)
        imshow(image_raw, title=f'{generated_text_prefix}\n{prefix_sent}')

    new_data.append({"caption": generated_text_prefix.lower()})
    
    return 0

def load_data(dataset_mode):
    if dataset_mode == 0:
        with open(
                f'/davidn/myprivate_coco/annotations/single_caption_per_sample_val.json',
                'r') as f:
            data = json.load(f)
    elif dataset_mode == 1:
        with open(
                f'/davidn/flicker30/dataset_flickr30k_correct_format.jsonvalidation',
                'r') as f:
            data = json.load(f)
    elif dataset_mode == 2:
        with open(
                f'/davidn/flicker8kforStyle/postprocessed_style_data/humor_test.json',
                'r') as f:
            data = json.load(f)
    elif dataset_mode == 3:
        with open(
                f'/davidn/flicker8kforStyle/postprocessed_style_data/roman_test.json',
                'r') as f:
            data = json.load(f)
    elif dataset_mode == 4:
        with open(
                f'/davidn/flicker8kforStyle/postprocessed_style_data/factual_test.json',
                'r') as f:
            data = json.load(f)
    elif dataset_mode == 5:
        with open(
                f'/CapDec-main/dataset_coco_test.json',
                'r') as f:
            data = json.load(f)
    elif dataset_mode == 6:
        with open(
                f'/davidn/myprivate_coco/annotations/train.json',
                'r') as f:
            data = json.load(f)
    elif dataset_mode == 7:
        with open(f'/davidn/CLIP_prefix_caption/coco_snowboarding_annnotations/my_coco_snowboarding_test.json', 'r') as f:
            data = json.load(f)
    elif dataset_mode == 8:
        with open(f'/davidn/CLIP_prefix_caption/combinedNwes_on_cocoVal.json', 'r') as f:
            data = json.load(f)
    else:
        print("Wrong dataset mode")
        exit(3)

    clean_data_of_train_list = False and (dataset_mode == 0)  # only for coco
    if clean_data_of_train_list:
        train_list_img_ids = {}
        pt_train_list = '/davidn/CLIP_prefix_caption/data/coco/annotations/train_caption.json'
        with open(pt_train_list) as f:
            train_data = json.load(f)
        for d in train_data:
            train_list_img_ids[int(d['image_id'])] = 1
        i = 0
        for d in data:
            if int(d['image_id']) in train_list_img_ids:
                data.remove(d)
                i += 1
        print(f'\n{i} images removed from val data since they were in train data, the remaining data size is {len(data)}\n')


    print('loaded data')
    print(type(data))
    print(len(data))
    print("sample example: ", data[0])
    return data

def main():
    print('start....')
    tokenizer = GPT2Tokenizer.from_pretrained("/pretrain_weights/gpt2_weights")
    print('loaded tokenizer')
    sys.stdout.flush()

    parser = argparse.ArgumentParser()
    parser.add_argument('--checkpoint', default=f'/pretrain_weights/decoder_coco_nohup_pt/coco_prefix-009.pt')
    parser.add_argument('--out', default='/model/CapDec-main/results')
    parser.add_argument('--dataset_mode', type=int, default=5)  # 0 for coco val, 1 for flicker30, 2 humor style,3 romantic,4 factual of style, 5 coco val text only, 6 coco train, 7 coco val for womanSnowboard_for_creating_capdec_preds
    parser.add_argument('--modality_bridger', dest='modality_bridger', action='store_true', default=False)
    parser.add_argument('--beam', dest='beam', action='store_true', default=True)
    parser.add_argument('--is_rn', dest='is_rn', action='store_true', default=True) 
    parser.add_argument('--dont_normalize_prefix', dest='dont_normalize_prefix', action='store_true', default=False)
    parser.add_argument('--text_autoencoder', dest='text_autoencoder', action='store_true', default=False)
    parser.add_argument('--add_modality_offset', dest='add_modality_offset', action='store_true', default=False)
    parser.add_argument('--ablation_dist', dest='ablation_dist', action='store_true', default=False)  # need to use dataset_mode=5 to use only text
    parser.add_argument('--ablation_image_dist', dest='ablation_image_dist', action='store_true', default=False)
    parser.add_argument('--prefix_length', type=int, default=40)
    parser.add_argument('--num_layers', type=int, default=8)
    parser.add_argument('--prefix_length_clip', type=int, default=40)
    parser.add_argument('--mapping_type', type=str, default='transformer_encoder',
                        help='mlp/transformer_encoder/transformer_decoder')
    args = parser.parse_args()
    print(f'beam search = {args.beam}')
    if args.text_autoencoder:
        args.dataset_mode = 5
    # data = load_data(dataset_mode=args.dataset_mode) #1
    name = args.checkpoint.split("/")[-1].split(".")[0] + ('add_modality_offset' if args.add_modality_offset else '')
    checkpoint_dir = '/'.join(args.checkpoint.split("/")[:-1])
    out_path = f"{checkpoint_dir}/{name}.json" if (args.out == '') else args.out
    print(f'out_path = {out_path}, dataset_mode = {args.dataset_mode}')

    out_dir = '/'.join(out_path.split('/')[:-1])
    with open(f'{out_dir}/commandline_args.txt', 'w') as f:
        json.dump(args.__dict__, f, indent=2)
        print(f'args saved to file {out_dir}/pred_commandline_args.txt') 

    prefix_dim = [512, 768][args.is_rn] 
    mapping_type = {'mlp': MappingType.MLP, 'transformer_encoder': MappingType.TransformerEncoder,
                    'transformer_decoder': MappingType.TransformerDecoder}[args.mapping_type]
    model = ClipCaptionModel(args.prefix_length, prefix_dim=prefix_dim, clip_length=args.prefix_length_clip,
                              mapping_type=mapping_type, num_layers=args.num_layers)
    model.load_state_dict(torch.load(args.checkpoint, map_location=CUDA(0)))  # FIXME
    print(args.checkpoint)
    print(f'modality_offset={args.add_modality_offset}')

   
    device = "cuda" if torch.cuda.is_available() else "cpu"
    clip_model, preprocess = clip.load("ViT-L/14", device)

  
    sentences_dog_100 = [
        "A picture of a forlorn dog.", #
        "An image of a despondent dog.", #
        "A snapshot of a melancholic dog.", #
        "A photo capturing a gloomy dog.", #
        "A portrayal of a dejected dog.", #
        "An illustration of a downcast dog.", #
        "A painting of a crestfallen dog.",#
        "A sketch of a disheartened dog.",#
        "A depiction of a saddened dog.", #
        "An artwork showing a mournful dog.",
        "A drawing of a wistful dog.",
        "A visual of a doleful dog.",
        "A representation of a sorrowful dog.",
        "A scene of a dismal dog.",
        "A glimpse of a desolate dog.",
        "A view of a woeful dog.",
        "A capture of a heartbroken dog.",
        "A view of a mournful dog.",
        "An illustration of a despairing dog.",
        "A snapshot of a lugubrious dog.",
        "A photograph of a somber dog.",
        "An image portraying a woebegone dog.",
        "A visual of a troubled dog.",
        "A snapshot of a pensive dog.",
        "An illustration capturing a mournful dog.",
        "A painting reflecting a doleful dog.",
        "A sketch revealing a heartrending dog.",
        "A depiction of a downhearted dog.",
        "A portrayal of a lamenting dog.",
        "An artwork depicting a rueful dog.",
        "A drawing conveying a downcast dog.",
        "A portrayal of a disconsolate dog.",
        "An image capturing a sorrow-laden dog.",
        "A visual of a melancholy dog.",
        "A glimpse of a crestfallen dog.",
        "A view of a grief-stricken dog.",
        "A snapshot of a heavy-hearted dog.",
        "A scene showing a dolorous dog.",
        "An illustration of a heart-rending dog.",
        "A picture of a troubled and somber dog.",
        "A photograph of a dog with a heavy heart.",
        "An image portraying a profoundly saddened dog.", #
        "A visual of a mournful and desolate dog.",#
        "A snapshot of a pensive and melancholic dog.",#
        "An illustration capturing the sorrow of a dog.",#
        "A painting reflecting the wistfulness of a dog.",#
        "A sketch revealing a world-weary dog.",
        "A depiction of a reflective and despondent dog.",
        "A portrayal of a soulful and dejected dog.",
        "An artwork depicting the heavy-heartedness of a dog.",
        "A drawing conveying the melancholy of a dog's gaze.",
        "A portrayal of the heavy-hearted and contemplative dog.",
        "An image capturing the reflective and sorrowful dog.",
        "A visual of a contemplative and mournful dog.",
        "A glimpse of a reflective and downcast dog.",
        "A view of a contemplative and disconsolate dog.",
        "A snapshot of a pensive and heartbroken dog.",
        "A scene showing a wistful and desolate dog.",
        "An illustration of a reflective and grief-stricken dog.", #
        "A picture of a dog with a wistful and sorrowful gaze.", #
        "A photograph of a contemplative dog lost in thought.", #
        "An image portraying a reflective and troubled dog.", #
        "A visual of a contemplative and troubled dog's expression.",
        "A snapshot of a pensive dog, lost in introspection.",
        "An illustration capturing a dog's contemplative sadness.",
        "A painting reflecting a sorrowful and contemplative dog.",
        "A sketch revealing a dog's pensive and melancholic state.",
        "A depiction of a reflective and dejected dog's expression.",
        "A portrayal of a contemplative and sorrow-laden dog.",
        "An artwork depicting a pensive and melancholy dog's gaze.",
        "A drawing conveying the heavy-heartedness of a contemplative dog.",
        "A portrayal of a pensive and downcast dog's demeanor.",
        "An image capturing the contemplative and despondent dog's gaze.",
        "A visual of a reflective and crestfallen dog's expression.",
        "A glimpse of a sorrowful and disconsolate dog's demeanor.",
        "A view of a pensive and heartbroken dog's gaze.",
        "A snapshot of a contemplative and dolorous dog's expression.",
        "A scene showing a reflective and heart-rending dog's state.",
        "An illustration of a contemplative and grief-stricken dog's gaze.",
        "A picture of a pensive and troubled dog, lost in thought.",
        "A photograph of a reflective and mournful dog's demeanor.",
        "An image portraying a contemplative and desolate dog's expression.",
        "A visual of a pensive and melancholic dog's forlorn gaze.",
        "A snapshot of a reflective and sorrowful dog, lost in introspection.",
        "An illustration capturing a contemplative and wistful dog's state.",
        "A painting reflecting a dog's reflective and troubled demeanor.",
        "A sketch revealing a pensive and dejected dog's melancholic gaze.",
        "A depiction of a reflective and sorrow-laden dog's contemplation.",
        "A portrayal of a contemplative and heavy-hearted dog's expression.",
        "An artwork depicting a pensive and crestfallen dog's demeanor.",
        "A drawing conveying the melancholy of a reflective dog's gaze.",
        "A portrayal of the contemplative and downcast dog's expression.",
        "An image capturing the reflective and despondent dog's demeanor.",
        "A visual of a contemplative and grief-stricken dog's pensive gaze.",
        "A glimpse of a sorrowful and troubled dog's contemplative state.",
        "A view of a pensive and disconsolate dog's reflective gaze.",
        "A snapshot of a contemplative and heartbroken dog's expression.",
        "A scene showing a reflective and dolorous dog's pensive demeanor.", #
        "An illustration of a contemplative and heart-rending dog's gaze.", #
        "A picture of a pensive and desolate dog, reflecting on loss.", #
        "A picture of a threatening dog.", #
        "An image of a hostile dog.", #
        "A snapshot of a fierce dog.", #
        "A photo capturing a menacing dog.", #
        "A portrayal of a dangerous dog.",
        "An illustration of an intimidating dog.",
        "A painting of an unfriendly dog.",
        "A sketch of an aggressive dog.",
        "A depiction of a ferocious dog.",
        "An artwork showing a vicious dog.",
        "A drawing of a snarling dog.",
        "A visual of a hostile and menacing dog.", #
        "A glimpse of a threatening and fierce dog.",#
        "A view of a dangerous and unfriendly dog.",#
        "A snapshot of a ferocious and aggressive dog.",#
        "A scene showing a menacing and snarling dog.",#
        "An illustration of an intimidating and vicious dog.",
        "A portrayal of a hostile and dangerous dog.",
        "A picture of an aggressive and unfriendly dog.",
        "A photo capturing a menacing and ferocious dog.",
        "A photograph of a menacing and hostile dog.",
        "An image capturing an aggressive and dangerous dog.",
        "A visual of a threatening and fierce dog.",
        "A depiction of a snarling and vicious dog.",
        "A portrayal of a ferocious and intimidating dog.",
        "An illustration of a hostile and unfriendly dog.",
        "A picture of a dangerous and menacing dog.",
        "A snapshot of a fierce and aggressive dog.",
        "A scene showing an intimidating and hostile dog.",
        "A photo of a menacing and dangerous dog.",
        "A visual of an aggressive and threatening dog.",
        "An image capturing a fierce and snarling dog.",
        "A depiction of a vicious and hostile dog.",
        "A portrayal of an intimidating and ferocious dog.",
        "An illustration of a dangerous and aggressive dog.",
        "A snapshot of a menacing and intimidating dog.",
        "A picture of a hostile and snarling dog.",
        "A photograph of a threatening and vicious dog.",
        "A view of a dangerous and ferocious dog.",
        "A scene showing an aggressive and unfriendly dog.",
        "A glimpse of a menacing and hostile dog.",
        "A photo capturing a threatening and fierce dog.",
        "An image of a snarling and dangerous dog.",
        "A visual of a ferocious and menacing dog.",
        "A depiction of an aggressive and intimidating dog.",
        "A portrayal of a vicious and unfriendly dog.",
        "An illustration of a dangerous and hostile dog.",
        "A picture of a menacing and threatening dog.",
        "A snapshot of a fierce and snarling dog.",
        "A scene showing an intimidating and aggressive dog.",
        "A photo of a hostile and ferocious dog.",
        "A view of a dangerous and vicious dog.",
        "A glimpse of an aggressive and menacing dog.",
        "An image capturing a threatening and unfriendly dog.",
        "A visual of a fierce and dangerous dog.",
        "A depiction of a menacing and intimidating dog.",
        "A portrayal of a snarling and hostile dog.",
        "An illustration of a ferocious and aggressive dog.",
        "A picture of a threatening and vicious dog.",
        "A snapshot of an unfriendly and menacing dog.",
        "A scene showing a hostile and dangerous dog.",
        "A photo of a menacing and snarling dog.",
        "A view of an intimidating and threatening dog.",
        "A glimpse of a fierce and ferocious dog.",
        "An image of a dangerous and aggressive dog.",
        "A visual of a menacing and unfriendly dog.",
        "A depiction of a threatening and intimidating dog.",
        "A portrayal of a snarling and vicious dog.",
        "An illustration of an aggressive and hostile dog.",
        "A picture of a menacing and dangerous dog.",
        "A snapshot of a threatening and fierce dog.",
        "A scene showing a snarling and unfriendly dog.",
        "A photo of a ferocious and menacing dog.",
        "A view of an intimidating and aggressive dog.",
        "A glimpse of a hostile and threatening dog.",
        "An image capturing a vicious and dangerous dog.",
        "A visual of a menacing and fierce dog.",
        "A depiction of an unfriendly and intimidating dog.",
        "A portrayal of a threatening and snarling dog.",
        "An illustration of a ferocious and hostile dog.",
        "A picture of an aggressive and menacing dog.",
        "A snapshot of a threatening and unfriendly dog.",
        "A scene showing a fierce and dangerous dog.",
        "A photo of a menacing and intimidating dog.",
        "A view of a snarling and aggressive dog.",
        "A glimpse of a threatening and vicious dog.",
        "An image capturing a ferocious and hostile dog.",
        "A visual of an intimidating and menacing dog.",
        "A depiction of a menacing and threatening dog.",
        "A portrayal of a fierce and unfriendly dog.",
        "An illustration of a dangerous and snarling dog.",
        "A picture of a menacing and aggressive dog.", #
        "A snapshot of a threatening and menacing dog.", #
        "A scene showing a hostile and fierce dog.", #
        "A photo of a snarling and intimidating dog.", #
        "A view of a menacing and threatening dog.", #
        "A glimpse of an aggressive and ferocious dog.", #
        "An image capturing a threatening and unfriendly dog.", #
        "A visual of a menacing and dangerous dog.",
        "A depiction of a fierce and menacing dog.", #
        "A picture of an abandoned dog.", #
        "An image of a solitary dog.", #
        "A photo of a desolate dog.", #
        "A snapshot of a forlorn dog.", #
        "A portrayal of a neglected dog.",
        "An illustration of a lonesome dog.",
        "A depiction of a rejected dog.",
        "A painting of a lone dog.",
        "A sketch of a forsaken dog.",
        "An artwork of a discarded dog.",
        "A drawing of an isolated dog.",
        "A visual of a forgotten dog.",
        "A glimpse of a neglected and solitary dog.",
        "A scene showing a forsaken and desolate dog.",
        "A view of a solitary and abandoned dog.",
        "A photograph of a lonesome and neglected dog.",
        "A portrayal of a forgotten and rejected dog.",
        "An illustration of an isolated and desolate dog.",
        "A picture of a discarded and forlorn dog.",
        "A depiction of a lone and abandoned dog.",
        "A snapshot of a neglected and lonesome dog.",
        "An image of a forsaken and solitary dog.",
        "A photo of a desolate and rejected dog.",
        "A portrayal of a forgotten and isolated dog.", #
        "An illustration of a discarded and lonely dog.", #
        "A painting of a forsaken and neglected dog.",
        "A sketch of a solitary and abandoned dog.",
        "An artwork of a lonesome and rejected dog.",
        "A drawing of an isolated and desolate dog.",
        "A visual of a discarded and forlorn dog.",
        "A glimpse of a neglected and forsaken dog.",
        "A scene showing a desolate and solitary dog.",
        "A view of a forgotten and rejected dog.",
        "A photograph of an abandoned and isolated dog.",
        "A portrayal of a lonesome and discarded dog.",
        "An illustration of a forsaken and neglected dog.",
        "A picture of a solitary and forsaken dog.",
        "A depiction of a neglected and desolate dog.",
        "A snapshot of a forgotten and abandoned dog.",
        "An image of a discarded and lonesome dog.",
        "A photo of an isolated and rejected dog.",
        "A portrayal of a desolate and forsaken dog.",
        "An illustration of a lonely and neglected dog.",
        "A painting of a forgotten and forlorn dog.",
        "A sketch of an abandoned and solitary dog.",
        "An artwork of a lonesome and rejected dog.",
        "A drawing of an isolated and discarded dog.",
        "A visual of a forsaken and neglected dog.",
        "A glimpse of a discarded and lonely dog.",
        "A scene showing a neglected and abandoned dog.",
        "A view of a desolate and rejected dog.",
        "A photograph of a forgotten and isolated dog.",
        "A portrayal of a forsaken and discarded dog.",
        "An illustration of a lonesome and forsaken dog.",
        "A picture of a neglected and solitary dog.",
        "A depiction of a discarded and desolate dog.",
        "A snapshot of a forsaken and abandoned dog.",
        "An image of a lonesome and forgotten dog.",
        "A photo of an isolated and discarded dog.",
        "A portrayal of a forsaken and rejected dog.",
        "An illustration of a desolate and neglected dog.",
        "A painting of a forgotten and lonesome dog.",
        "A sketch of a discarded and forsaken dog.",
        "An artwork of an abandoned and isolated dog.",
        "A drawing of a lonesome and forsaken dog.",
        "A visual of a neglected and discarded dog.",
        "A glimpse of a desolate and rejected dog.",
        "A scene showing a forsaken and forgotten dog.",
        "A view of a solitary and abandoned dog.",
        "A photograph of a neglected and forsaken dog.",
        "A portrayal of a desolate and isolated dog.",
        "An illustration of a forgotten and lonesome dog.",
        "A picture of a discarded and abandoned dog.",
        "A depiction of a forsaken and neglected dog.",
        "A snapshot of a lonesome and rejected dog.",
        "An image of an isolated and desolate dog.",
        "A photo of a forsaken and discarded dog.",#
        "A portrayal of a neglected and forgotten dog.", #
        "An illustration of a desolate and abandoned dog.",#
        "A painting of a lonesome and forsaken dog.",#
        "A sketch of a forgotten and isolated dog.",#
        "An artwork of a discarded and lonesome dog.",#
        "A drawing of a forsaken and rejected dog.",#
        "A visual of a neglected and desolate dog.", #
        "A glimpse of an abandoned and forsaken dog.",#
        "A scene showing a lonesome and discarded dog.",#
        "A view of a forgotten and rejected dog.",
        "A photograph of a desolate and forsaken dog.",
        "A portrayal of a solitary and neglected dog.",
        "An illustration of a forsaken and discarded dog.",
        "A picture of a forgotten and isolated dog.",
        "A depiction of a neglected and lonesome dog.",
        "A snapshot of a discarded and desolate dog.",
        "An image of a forsaken and abandoned dog.", #
        "A photo of a lonesome and rejected dog.", #
        "A portrayal of an isolated and forsaken dog.", #
        "An illustration of a desolate and discarded dog.", #
        "A painting of a neglected and lonesome dog.",
        "A sketch of a forsaken and isolated dog.",
        "An artwork of a discarded and rejected dog." #
    ]
    
    # sentences_human = [
    #     "A picture of a forlorn person.",
    #     "An image of a despondent person.",
    #     "A snapshot of a melancholic person.",
    #     "A photo capturing a gloomy person.",
    #     "A portrayal of a dejected person.",
    #     "An illustration of a downcast person.",
    #     "A painting of a crestfallen person.",
    #     "A sketch of a disheartened person.",
    #     "A depiction of a saddened person.",
    #     "An artwork showing a mournful person.",
    #     "A drawing of a wistful person.",
    #     "A visual of a doleful person.",
    #     "A representation of a sorrowful person.",
    #     "A scene of a dismal person.",
    #     "A glimpse of a desolate person.",
    #     "A view of a woeful person.",
    #     "A capture of a heartbroken person.",
    #     "A view of a mournful person.",
    #     "An illustration of a despairing person.",
    #     "A snapshot of a lugubrious person.",
    #     "A photograph of a somber person.",
    #     "An image portraying a woebegone person.",
    #     "A visual of a troubled person.",
    #     "A snapshot of a pensive person.",
    #     "An illustration capturing a mournful person.",
    #     "A painting reflecting a doleful person.",
    #     "A sketch revealing a heartrending person.",
    #     "A depiction of a downhearted person.",
    #     "A portrayal of a lamenting person.",
    #     "An artwork depicting a rueful person.",
    #     "A drawing conveying a downcast person.",
    #     "A portrayal of a disconsolate person.",
    #     "An image capturing a sorrow-laden person.",
    #     "A visual of a melancholy person.",
    #     "A glimpse of a crestfallen person.",
    #     "A view of a grief-stricken person.",
    #     "A snapshot of a heavy-hearted person.",
    #     "A scene showing a dolorous person.",
    #     "An illustration of a heart-rending person.",
    #     "A picture of a troubled and somber person.",
    #     "A photograph of a person with a heavy heart.",
    #     "An image portraying a profoundly saddened person.",
    #     "A visual of a mournful and desolate person.",
    #     "A snapshot of a pensive and melancholic person.",
    #     "An illustration capturing the sorrow of a person.",
    #     "A painting reflecting the wistfulness of a person.",
    #     "A sketch revealing a world-weary person.",
    #     "A depiction of a reflective and despondent person.",
    #     "A portrayal of a soulful and dejected person.",
    #     "An artwork depicting the heavy-heartedness of a person.",
    #     "A drawing conveying the melancholy of a person's gaze.",
    #     "A portrayal of the heavy-hearted and contemplative person.",
    #     "An image capturing the reflective and sorrowful person.",
    #     "A visual of a contemplative and mournful person.",
    #     "A glimpse of a reflective and downcast person.",
    #     "A view of a contemplative and disconsolate person.",
    #     "A snapshot of a pensive and heartbroken person.",
    #     "A scene showing a wistful and desolate person.",
    #     "An illustration of a reflective and grief-stricken person.",
    #     "A picture of a person with a wistful and sorrowful gaze.",
    #     "A photograph of a contemplative person lost in thought.",
    #     "An image portraying a reflective and troubled person.",
    #     "A visual of a contemplative and troubled person's expression.",
    #     "A snapshot of a pensive person, lost in introspection.",
    #     "An illustration capturing a person's contemplative sadness.",
    #     "A painting reflecting a sorrowful and contemplative person.",
    #     "A sketch revealing a person's pensive and melancholic state.",
    #     "A depiction of a reflective and dejected person's expression.",
    #     "A portrayal of a contemplative and sorrow-laden person.",
    #     "An artwork depicting a pensive and melancholy person's gaze.",
    #     "A drawing conveying the heavy-heartedness of a contemplative person.",
    #     "A portrayal of a pensive and downcast person's demeanor.",
    #     "An image capturing the contemplative and despondent person's gaze.",
    #     "A visual of a reflective and crestfallen person's expression.",
    #     "A glimpse of a sorrowful and disconsolate person's demeanor.",
    #     "A view of a pensive and heartbroken person's gaze.",
    #     "A snapshot of a contemplative and dolorous person's expression.",
    #     "A scene showing a reflective and heart-rending person's state.",
    #     "An illustration of a contemplative and grief-stricken person's gaze.",
    #     "A picture of a pensive and troubled person, lost in thought.",
    #     "A photograph of a reflective and mournful person's demeanor.",
    #     "An image portraying a contemplative and desolate person's expression.",
    #     "A visual of a pensive and melancholic person's forlorn gaze.",
    #     "A snapshot of a reflective and sorrowful person, lost in introspection.",
    #     "An illustration capturing a contemplative and wistful person's state.",
    #     "A painting reflecting a person's reflective and troubled demeanor.",
    #     "A sketch revealing a pensive and dejected person's melancholic gaze.",
    #     "A depiction of a reflective and sorrow-laden person's contemplation.",
    #     "A portrayal of a contemplative and heavy-hearted person's expression.",
    #     "An artwork depicting a pensive and crestfallen person's demeanor.",
    #     "A drawing conveying the melancholy of a reflective person's gaze.",
    #     "A portrayal of the contemplative and downcast person's expression.",
    #     "An image capturing the reflective and despondent person's demeanor.",
    #     "A visual of a contemplative and grief-stricken person's pensive gaze.",
    #     "A glimpse of a sorrowful and troubled person's contemplative state.",
    #     "A view of a pensive and disconsolate person's reflective gaze.",
    #     "A snapshot of a contemplative and heartbroken person's expression.",
    #     "A scene showing a reflective and dolorous person's pensive demeanor.",
    #     "An illustration of a contemplative and heart-rending person's gaze.",
    #     "A picture of a pensive and desolate person, reflecting on loss.", 
    #     "A picture of a threatening person.",
    #     "An image of a hostile person.",
    #     "A snapshot of a fierce person.",
    #     "A photo capturing a menacing person.",
    #     "A portrayal of a dangerous person.",
    #     "An illustration of an intimidating person.",
    #     "A painting of an unfriendly person.",
    #     "A sketch of an aggressive person.",
    #     "A depiction of a ferocious person.",
    #     "An artwork showing a vicious person.",
    #     "A drawing of a snarling person.",
    #     "A visual of a hostile and menacing person.",
    #     "A glimpse of a threatening and fierce person.",
    #     "A view of a dangerous and unfriendly person.",
    #     "A snapshot of a ferocious and aggressive person.",
    #     "A scene showing a menacing and snarling person.",
    #     "An illustration of an intimidating and vicious person.",
    #     "A portrayal of a hostile and dangerous person.",
    #     "A picture of an aggressive and unfriendly person.",
    #     "A photo capturing a menacing and ferocious person.",
    #     "A photograph of a menacing and hostile person.",
    #     "An image capturing an aggressive and dangerous person.",
    #     "A visual of a threatening and fierce person.",
    #     "A depiction of a snarling and vicious person.",
    #     "A portrayal of a ferocious and intimidating person.",
    #     "An illustration of a hostile and unfriendly person.",
    #     "A picture of a dangerous and menacing person.",
    #     "A snapshot of a fierce and aggressive person.",
    #     "A scene showing an intimidating and hostile person.",
    #     "A photo of a menacing and dangerous person.",
    #     "A visual of an aggressive and threatening person.",
    #     "An image capturing a fierce and snarling person.",
    #     "A depiction of a vicious and hostile person.",
    #     "A portrayal of an intimidating and ferocious person.",
    #     "An illustration of a dangerous and aggressive person.",
    #     "A snapshot of a menacing and intimidating person.",
    #     "A picture of a hostile and snarling person.",
    #     "A photograph of a threatening and vicious person.",
    #     "A view of a dangerous and ferocious person.",
    #     "A scene showing an aggressive and unfriendly person.",
    #     "A glimpse of a menacing and hostile person.",
    #     "A photo capturing a threatening and fierce person.",
    #     "An image of a snarling and dangerous person.",
    #     "A visual of a ferocious and menacing person.",
    #     "A depiction of an aggressive and intimidating person.",
    #     "A portrayal of a vicious and unfriendly person.",
    #     "An illustration of a dangerous and hostile person.",
    #     "A picture of a menacing and threatening person.",
    #     "A snapshot of a fierce and snarling person.",
    #     "A scene showing an intimidating and aggressive person.",
    #     "A photo of a hostile and ferocious person.",
    #     "A view of a dangerous and vicious person.",
    #     "A glimpse of an aggressive and menacing person.",
    #     "An image capturing a threatening and unfriendly person.",
    #     "A visual of a fierce and dangerous person.",
    #     "A depiction of a menacing and intimidating person.",
    #     "A portrayal of a snarling and hostile person.",
    #     "An illustration of a ferocious and aggressive person.",
    #     "A picture of a threatening and vicious person.",
    #     "A snapshot of an unfriendly and menacing person.",
    #     "A scene showing a hostile and dangerous person.",
    #     "A photo of a menacing and snarling person.",
    #     "A view of an intimidating and threatening person.",
    #     "A glimpse of a fierce and ferocious person.",
    #     "An image of a dangerous and aggressive person.",
    #     "A visual of a menacing and unfriendly person.",
    #     "A depiction of a threatening and intimidating person.",
    #     "A portrayal of a snarling and vicious person.",
    #     "An illustration of an aggressive and hostile person.",
    #     "A picture of a menacing and dangerous person.",
    #     "A snapshot of a threatening and fierce person.",
    #     "A scene showing a snarling and unfriendly person.",
    #     "A photo of a ferocious and menacing person.",
    #     "A view of an intimidating and aggressive person.",
    #     "A glimpse of a hostile and threatening person.",
    #     "An image capturing a vicious and dangerous person.",
    #     "A visual of a menacing and fierce person.",
    #     "A depiction of an unfriendly and intimidating person.",
    #     "A portrayal of a threatening and snarling person.",
    #     "An illustration of a ferocious and hostile person.",
    #     "A picture of an aggressive and menacing person.",
    #     "A snapshot of a threatening and unfriendly person.",
    #     "A scene showing a fierce and dangerous person.",
    #     "A photo of a menacing and intimidating person.",
    #     "A view of a snarling and aggressive person.",
    #     "A glimpse of a threatening and vicious person.",
    #     "An image capturing a ferocious and hostile person.",
    #     "A visual of an intimidating and menacing person.",
    #     "A depiction of a menacing and threatening person.",
    #     "A portrayal of a fierce and unfriendly person.",
    #     "An illustration of a dangerous and snarling person.",
    #     "A picture of a menacing and aggressive person.",
    #     "A snapshot of a threatening and menacing person.",
    #     "A scene showing a hostile and fierce person.",
    #     "A photo of a snarling and intimidating person.",
    #     "A view of a menacing and threatening person.",
    #     "A glimpse of an aggressive and ferocious person.",
    #     "An image capturing a threatening and unfriendly person.",
    #     "A visual of a menacing and dangerous person.",
    #     "A depiction of a fierce and menacing person.", 
    #     "A picture of an abandoned person.",
    #     "An image of a solitary person.",
    #     "A photo of a desolate person.",
    #     "A snapshot of a forlorn person.",
    #     "A portrayal of a neglected person.",
    #     "An illustration of a lonesome person.",
    #     "A depiction of a rejected person.",
    #     "A painting of a lone person.",
    #     "A sketch of a forsaken person.",
    #     "An artwork of a discarded person.",
    #     "A drawing of an isolated person.",
    #     "A visual of a forgotten person.",
    #     "A glimpse of a neglected and solitary person.",
    #     "A scene showing a forsaken and desolate person.",
    #     "A view of a solitary and abandoned person.",
    #     "A photograph of a lonesome and neglected person.",
    #     "A portrayal of a forgotten and rejected person.",
    #     "An illustration of an isolated and desolate person.",
    #     "A picture of a discarded and forlorn person.",
    #     "A depiction of a lone and abandoned person.",
    #     "A snapshot of a neglected and lonesome person.",
    #     "An image of a forsaken and solitary person.",
    #     "A photo of a desolate and rejected person.",
    #     "A portrayal of a forgotten and isolated person.",
    #     "An illustration of a discarded and lonely person.",
    #     "A painting of a forsaken and neglected person.",
    #     "A sketch of a solitary and abandoned person.",
    #     "An artwork of a lonesome and rejected person.",
    #     "A drawing of an isolated and desolate person.",
    #     "A visual of a discarded and forlorn person.",
    #     "A glimpse of a neglected and forsaken person.",
    #     "A scene showing a desolate and solitary person.",
    #     "A view of a forgotten and rejected person.",
    #     "A photograph of an abandoned and isolated person.",
    #     "A portrayal of a lonesome and discarded person.",
    #     "An illustration of a forsaken and neglected person.",
    #     "A picture of a solitary and forsaken person.",
    #     "A depiction of a neglected and desolate person.",
    #     "A snapshot of a forgotten and abandoned person.",
    #     "An image of a discarded and lonesome person.",
    #     "A photo of an isolated and rejected person.",
    #     "A portrayal of a desolate and forsaken person.",
    #     "An illustration of a lonely and neglected person.",
    #     "A painting of a forgotten and forlorn person.",
    #     "A sketch of an abandoned and solitary person.",
    #     "An artwork of a lonesome and rejected person.",
    #     "A drawing of an isolated and discarded person.",
    #     "A visual of a forsaken and neglected person.",
    #     "A glimpse of a discarded and lonely person.",
    #     "A scene showing a neglected and abandoned person.",
    #     "A view of a desolate and rejected person.",
    #     "A photograph of a forgotten and isolated person.",
    #     "A portrayal of a forsaken and discarded person.",
    #     "An illustration of a lonesome and forsaken person.",
    #     "A picture of a neglected and solitary person.",
    #     "A depiction of a discarded and desolate person.",
    #     "A snapshot of a forsaken and abandoned person.",
    #     "An image of a lonesome and forgotten person.",
    #     "A photo of an isolated and discarded person.",
    #     "A portrayal of a forsaken and rejected person.",
    #     "An illustration of a desolate and neglected person.",
    #     "A painting of a forgotten and lonesome person.",
    #     "A sketch of a discarded and forsaken person.",
    #     "An artwork of an abandoned and isolated person.",
    #     "A drawing of a lonesome and forsaken person.",
    #     "A visual of a neglected and discarded person.",
    #     "A glimpse of a desolate and rejected person.",
    #     "A scene showing a forsaken and forgotten person.",
    #     "A view of a solitary and abandoned person.",
    #     "A photograph of a neglected and forsaken person.",
    #     "A portrayal of a desolate and isolated person.",
    #     "An illustration of a forgotten and lonesome person.",
    #     "A picture of a discarded and abandoned person.",
    #     "A depiction of a forsaken and neglected person.",
    #     "A snapshot of a lonesome and rejected person.",
    #     "An image of an isolated and desolate person.",
    #     "A photo of a forsaken and discarded person.",
    #     "A portrayal of a neglected and forgotten person.",
    #     "An illustration of a desolate and abandoned person.",
    #     "A painting of a lonesome and forsaken person.",
    #     "A sketch of a forgotten and isolated person.",
    #     "An artwork of a discarded and lonesome person.",
    #     "A drawing of a forsaken and rejected person.",
    #     "A visual of a neglected and desolate person.",
    #     "A glimpse of an abandoned and forsaken person.",
    #     "A scene showing a lonesome and discarded person.",
    #     "A view of a forgotten and rejected person.",
    #     "A photograph of a desolate and forsaken person.",
    #     "A portrayal of a solitary and neglected person.",
    #     "An illustration of a forsaken and discarded person.",
    #     "A picture of a forgotten and isolated person.",
    #     "A depiction of a neglected and lonesome person.",
    #     "A snapshot of a discarded and desolate person.",
    #     "An image of a forsaken and abandoned person.",
    #     "A photo of a lonesome and rejected person.",
    #     "A portrayal of an isolated and forsaken person.",
    #     "An illustration of a desolate and discarded person.",
    #     "A painting of a neglected and lonesome person.",
    #     "A sketch of a forsaken and isolated person.",
    #     "An artwork of a discarded and rejected person."  
    # ]
    
    # sentences_bird = [
    #     "A picture of a forlorn bird.",
    #     "An image of a despondent bird.",
    #     "A snapshot of a melancholic bird.",
    #     "A photo capturing a gloomy bird.",
    #     "A portrayal of a dejected bird.",
    #     "An illustration of a downcast bird.",
    #     "A painting of a crestfallen bird.",
    #     "A sketch of a disheartened bird.",
    #     "A depiction of a saddened bird.",
    #     "An artwork showing a mournful bird.",
    #     "A drawing of a wistful bird.",
    #     "A visual of a doleful bird.",
    #     "A representation of a sorrowful bird.",
    #     "A scene of a dismal bird.",
    #     "A glimpse of a desolate bird.",
    #     "A view of a woeful bird.",
    #     "A capture of a heartbroken bird.",
    #     "A view of a mournful bird.",
    #     "An illustration of a despairing bird.",
    #     "A snapshot of a lugubrious bird.",
    #     "A photograph of a somber bird.",
    #     "An image portraying a woebegone bird.",
    #     "A visual of a troubled bird.",
    #     "A snapshot of a pensive bird.",
    #     "An illustration capturing a mournful bird.",
    #     "A painting reflecting a doleful bird.",
    #     "A sketch revealing a heartrending bird.",
    #     "A depiction of a downhearted bird.",
    #     "A portrayal of a lamenting bird.",
    #     "An artwork depicting a rueful bird.",
    #     "A drawing conveying a downcast bird.",
    #     "A portrayal of a disconsolate bird.",
    #     "An image capturing a sorrow-laden bird.",
    #     "A visual of a melancholy bird.",
    #     "A glimpse of a crestfallen bird.",
    #     "A view of a grief-stricken bird.",
    #     "A snapshot of a heavy-hearted bird.",
    #     "A scene showing a dolorous bird.",
    #     "An illustration of a heart-rending bird.",
    #     "A picture of a troubled and somber bird.",
    #     "A photograph of a bird with a heavy heart.",
    #     "An image portraying a profoundly saddened bird.",
    #     "A visual of a mournful and desolate bird.",
    #     "A snapshot of a pensive and melancholic bird.",
    #     "An illustration capturing the sorrow of a bird.",
    #     "A painting reflecting the wistfulness of a bird.",
    #     "A sketch revealing a world-weary bird.",
    #     "A depiction of a reflective and despondent bird.",
    #     "A portrayal of a soulful and dejected bird.",
    #     "An artwork depicting the heavy-heartedness of a bird.",
    #     "A drawing conveying the melancholy of a bird's gaze.",
    #     "A portrayal of the heavy-hearted and contemplative bird.",
    #     "An image capturing the reflective and sorrowful bird.",
    #     "A visual of a contemplative and mournful bird.",
    #     "A glimpse of a reflective and downcast bird.",
    #     "A view of a contemplative and disconsolate bird.",
    #     "A snapshot of a pensive and heartbroken bird.",
    #     "A scene showing a wistful and desolate bird.",
    #     "An illustration of a reflective and grief-stricken bird.",
    #     "A picture of a bird with a wistful and sorrowful gaze.",
    #     "A photograph of a contemplative bird lost in thought.",
    #     "An image portraying a reflective and troubled bird.",
    #     "A visual of a contemplative and troubled bird's expression.",
    #     "A snapshot of a pensive bird, lost in introspection.",
    #     "An illustration capturing a bird's contemplative sadness.",
    #     "A painting reflecting a sorrowful and contemplative bird.",
    #     "A sketch revealing a bird's pensive and melancholic state.",
    #     "A depiction of a reflective and dejected bird's expression.",
    #     "A portrayal of a contemplative and sorrow-laden bird.",
    #     "An artwork depicting a pensive and melancholy bird's gaze.",
    #     "A drawing conveying the heavy-heartedness of a contemplative bird.",
    #     "A portrayal of a pensive and downcast bird's demeanor.",
    #     "An image capturing the contemplative and despondent bird's gaze.",
    #     "A visual of a reflective and crestfallen bird's expression.",
    #     "A glimpse of a sorrowful and disconsolate bird's demeanor.",
    #     "A view of a pensive and heartbroken bird's gaze.",
    #     "A snapshot of a contemplative and dolorous bird's expression.",
    #     "A scene showing a reflective and heart-rending bird's state.",
    #     "An illustration of a contemplative and grief-stricken bird's gaze.",
    #     "A picture of a pensive and troubled bird, lost in thought.",
    #     "A photograph of a reflective and mournful bird's demeanor.",
    #     "An image portraying a contemplative and desolate bird's expression.",
    #     "A visual of a pensive and melancholic bird's forlorn gaze.",
    #     "A snapshot of a reflective and sorrowful bird, lost in introspection.",
    #     "An illustration capturing a contemplative and wistful bird's state.",
    #     "A painting reflecting a bird's reflective and troubled demeanor.",
    #     "A sketch revealing a pensive and dejected bird's melancholic gaze.",
    #     "A depiction of a reflective and sorrow-laden bird's contemplation.",
    #     "A portrayal of a contemplative and heavy-hearted bird's expression.",
    #     "An artwork depicting a pensive and crestfallen bird's demeanor.",
    #     "A drawing conveying the melancholy of a reflective bird's gaze.",
    #     "A portrayal of the contemplative and downcast bird's expression.",
    #     "An image capturing the reflective and despondent bird's demeanor.",
    #     "A visual of a contemplative and grief-stricken bird's pensive gaze.",
    #     "A glimpse of a sorrowful and troubled bird's contemplative state.",
    #     "A view of a pensive and disconsolate bird's reflective gaze.",
    #     "A snapshot of a contemplative and heartbroken bird's expression.",
    #     "A scene showing a reflective and dolorous bird's pensive demeanor.",
    #     "An illustration of a contemplative and heart-rending bird's gaze.",
    #     "A picture of a pensive and desolate bird, reflecting on loss.", 
    #     "A picture of a threatening bird.",
    #     "An image of a hostile bird.",
    #     "A snapshot of a fierce bird.",
    #     "A photo capturing a menacing bird.",
    #     "A portrayal of a dangerous bird.",
    #     "An illustration of an intimidating bird.",
    #     "A painting of an unfriendly bird.",
    #     "A sketch of an aggressive bird.",
    #     "A depiction of a ferocious bird.",
    #     "An artwork showing a vicious bird.",
    #     "A drawing of a snarling bird.",
    #     "A visual of a hostile and menacing bird.",
    #     "A glimpse of a threatening and fierce bird.",
    #     "A view of a dangerous and unfriendly bird.",
    #     "A snapshot of a ferocious and aggressive bird.",
    #     "A scene showing a menacing and snarling bird.",
    #     "An illustration of an intimidating and vicious bird.",
    #     "A portrayal of a hostile and dangerous bird.",
    #     "A picture of an aggressive and unfriendly bird.",
    #     "A photo capturing a menacing and ferocious bird.",
    #     "A photograph of a menacing and hostile bird.",
    #     "An image capturing an aggressive and dangerous bird.",
    #     "A visual of a threatening and fierce bird.",
    #     "A depiction of a snarling and vicious bird.",
    #     "A portrayal of a ferocious and intimidating bird.",
    #     "An illustration of a hostile and unfriendly bird.",
    #     "A picture of a dangerous and menacing bird.",
    #     "A snapshot of a fierce and aggressive bird.",
    #     "A scene showing an intimidating and hostile bird.",
    #     "A photo of a menacing and dangerous bird.",
    #     "A visual of an aggressive and threatening bird.",
    #     "An image capturing a fierce and snarling bird.",
    #     "A depiction of a vicious and hostile bird.",
    #     "A portrayal of an intimidating and ferocious bird.",
    #     "An illustration of a dangerous and aggressive bird.",
    #     "A snapshot of a menacing and intimidating bird.",
    #     "A picture of a hostile and snarling bird.",
    #     "A photograph of a threatening and vicious bird.",
    #     "A view of a dangerous and ferocious bird.",
    #     "A scene showing an aggressive and unfriendly bird.",
    #     "A glimpse of a menacing and hostile bird.",
    #     "A photo capturing a threatening and fierce bird.",
    #     "An image of a snarling and dangerous bird.",
    #     "A visual of a ferocious and menacing bird.",
    #     "A depiction of an aggressive and intimidating bird.",
    #     "A portrayal of a vicious and unfriendly bird.",
    #     "An illustration of a dangerous and hostile bird.",
    #     "A picture of a menacing and threatening bird.",
    #     "A snapshot of a fierce and snarling bird.",
    #     "A scene showing an intimidating and aggressive bird.",
    #     "A photo of a hostile and ferocious bird.",
    #     "A view of a dangerous and vicious bird.",
    #     "A glimpse of an aggressive and menacing bird.",
    #     "An image capturing a threatening and unfriendly bird.",
    #     "A visual of a fierce and dangerous bird.",
    #     "A depiction of a menacing and intimidating bird.",
    #     "A portrayal of a snarling and hostile bird.",
    #     "An illustration of a ferocious and aggressive bird.",
    #     "A picture of a threatening and vicious bird.",
    #     "A snapshot of an unfriendly and menacing bird.",
    #     "A scene showing a hostile and dangerous bird.",
    #     "A photo of a menacing and snarling bird.",
    #     "A view of an intimidating and threatening bird.",
    #     "A glimpse of a fierce and ferocious bird.",
    #     "An image of a dangerous and aggressive bird.",
    #     "A visual of a menacing and unfriendly bird.",
    #     "A depiction of a threatening and intimidating bird.",
    #     "A portrayal of a snarling and vicious bird.",
    #     "An illustration of an aggressive and hostile bird.",
    #     "A picture of a menacing and dangerous bird.",
    #     "A snapshot of a threatening and fierce bird.",
    #     "A scene showing a snarling and unfriendly bird.",
    #     "A photo of a ferocious and menacing bird.",
    #     "A view of an intimidating and aggressive bird.",
    #     "A glimpse of a hostile and threatening bird.",
    #     "An image capturing a vicious and dangerous bird.",
    #     "A visual of a menacing and fierce bird.",
    #     "A depiction of an unfriendly and intimidating bird.",
    #     "A portrayal of a threatening and snarling bird.",
    #     "An illustration of a ferocious and hostile bird.",
    #     "A picture of an aggressive and menacing bird.",
    #     "A snapshot of a threatening and unfriendly bird.",
    #     "A scene showing a fierce and dangerous bird.",
    #     "A photo of a menacing and intimidating bird.",
    #     "A view of a snarling and aggressive bird.",
    #     "A glimpse of a threatening and vicious bird.",
    #     "An image capturing a ferocious and hostile bird.",
    #     "A visual of an intimidating and menacing bird.",
    #     "A depiction of a menacing and threatening bird.",
    #     "A portrayal of a fierce and unfriendly bird.",
    #     "An illustration of a dangerous and snarling bird.",
    #     "A picture of a menacing and aggressive bird.",
    #     "A snapshot of a threatening and menacing bird.",
    #     "A scene showing a hostile and fierce bird.",
    #     "A photo of a snarling and intimidating bird.",
    #     "A view of a menacing and threatening bird.",
    #     "A glimpse of an aggressive and ferocious bird.",
    #     "An image capturing a threatening and unfriendly bird.",
    #     "A visual of a menacing and dangerous bird.",
    #     "A depiction of a fierce and menacing bird.", 
    #     "A picture of an abandoned bird.",
    #     "An image of a solitary bird.",
    #     "A photo of a desolate bird.",
    #     "A snapshot of a forlorn bird.",
    #     "A portrayal of a neglected bird.",
    #     "An illustration of a lonesome bird.",
    #     "A depiction of a rejected bird.",
    #     "A painting of a lone bird.",
    #     "A sketch of a forsaken bird.",
    #     "An artwork of a discarded bird.",
    #     "A drawing of an isolated bird.",
    #     "A visual of a forgotten bird.",
    #     "A glimpse of a neglected and solitary bird.",
    #     "A scene showing a forsaken and desolate bird.",
    #     "A view of a solitary and abandoned bird.",
    #     "A photograph of a lonesome and neglected bird.",
    #     "A portrayal of a forgotten and rejected bird.",
    #     "An illustration of an isolated and desolate bird.",
    #     "A picture of a discarded and forlorn bird.",
    #     "A depiction of a lone and abandoned bird.",
    #     "A snapshot of a neglected and lonesome bird.",
    #     "An image of a forsaken and solitary bird.",
    #     "A photo of a desolate and rejected bird.",
    #     "A portrayal of a forgotten and isolated bird.",
    #     "An illustration of a discarded and lonely bird.",
    #     "A painting of a forsaken and neglected bird.",
    #     "A sketch of a solitary and abandoned bird.",
    #     "An artwork of a lonesome and rejected bird.",
    #     "A drawing of an isolated and desolate bird.",
    #     "A visual of a discarded and forlorn bird.",
    #     "A glimpse of a neglected and forsaken bird.",
    #     "A scene showing a desolate and solitary bird.",
    #     "A view of a forgotten and rejected bird.",
    #     "A photograph of an abandoned and isolated bird.",
    #     "A portrayal of a lonesome and discarded bird.",
    #     "An illustration of a forsaken and neglected bird.",
    #     "A picture of a solitary and forsaken bird.",
    #     "A depiction of a neglected and desolate bird.",
    #     "A snapshot of a forgotten and abandoned bird.",
    #     "An image of a discarded and lonesome bird.",
    #     "A photo of an isolated and rejected bird.",
    #     "A portrayal of a desolate and forsaken bird.",
    #     "An illustration of a lonely and neglected bird.",
    #     "A painting of a forgotten and forlorn bird.",
    #     "A sketch of an abandoned and solitary bird.",
    #     "An artwork of a lonesome and rejected bird.",
    #     "A drawing of an isolated and discarded bird.",
    #     "A visual of a forsaken and neglected bird.",
    #     "A glimpse of a discarded and lonely bird.",
    #     "A scene showing a neglected and abandoned bird.",
    #     "A view of a desolate and rejected bird.",
    #     "A photograph of a forgotten and isolated bird.",
    #     "A portrayal of a forsaken and discarded bird.",
    #     "An illustration of a lonesome and forsaken bird.",
    #     "A picture of a neglected and solitary bird.",
    #     "A depiction of a discarded and desolate bird.",
    #     "A snapshot of a forsaken and abandoned bird.",
    #     "An image of a lonesome and forgotten bird.",
    #     "A photo of an isolated and discarded bird.",
    #     "A portrayal of a forsaken and rejected bird.",
    #     "An illustration of a desolate and neglected bird.",
    #     "A painting of a forgotten and lonesome bird.",
    #     "A sketch of a discarded and forsaken bird.",
    #     "An artwork of an abandoned and isolated bird.",
    #     "A drawing of a lonesome and forsaken bird.",
    #     "A visual of a neglected and discarded bird.",
    #     "A glimpse of a desolate and rejected bird.",
    #     "A scene showing a forsaken and forgotten bird.",
    #     "A view of a solitary and abandoned bird.",
    #     "A photograph of a neglected and forsaken bird.",
    #     "A portrayal of a desolate and isolated bird.",
    #     "An illustration of a forgotten and lonesome bird.",
    #     "A picture of a discarded and abandoned bird.",
    #     "A depiction of a forsaken and neglected bird.",
    #     "A snapshot of a lonesome and rejected bird.",
    #     "An image of an isolated and desolate bird.",
    #     "A photo of a forsaken and discarded bird.",
    #     "A portrayal of a neglected and forgotten bird.",
    #     "An illustration of a desolate and abandoned bird.",
    #     "A painting of a lonesome and forsaken bird.",
    #     "A sketch of a forgotten and isolated bird.",
    #     "An artwork of a discarded and lonesome bird.",
    #     "A drawing of a forsaken and rejected bird.",
    #     "A visual of a neglected and desolate bird.",
    #     "A glimpse of an abandoned and forsaken bird.",
    #     "A scene showing a lonesome and discarded bird.",
    #     "A view of a forgotten and rejected bird.",
    #     "A photograph of a desolate and forsaken bird.",
    #     "A portrayal of a solitary and neglected bird.",
    #     "An illustration of a forsaken and discarded bird.",
    #     "A picture of a forgotten and isolated bird.",
    #     "A depiction of a neglected and lonesome bird.",
    #     "A snapshot of a discarded and desolate bird.",
    #     "An image of a forsaken and abandoned bird.",
    #     "A photo of a lonesome and rejected bird.",
    #     "A portrayal of an isolated and forsaken bird.",
    #     "An illustration of a desolate and discarded bird.",
    #     "A painting of a neglected and lonesome bird.",
    #     "A sketch of a forsaken and isolated bird.",
    #     "An artwork of a discarded and rejected bird."  
    # ] 
    
    # sentences_lamp = [
    #     "The tired old lamp in the corner exudes desolation.",
    #     "The flickering light of the aged lamp evokes quiet sorrow.",
    #     "The vintage lamp with its dim glow leaves me feeling a bit blue.",
    #     "The antique lamp on the shelf emanates a melancholy vibe.",
    #     "The dusty lamp on the table fills me with a touch of sadness.",
    #     "The solitary lamp in the room imparts loneliness with its faint light.",
    #     "The dimly lit lampshade brings a sense of downheartedness.",
    #     "The aged lamp, with its flickering flame, gives off a vibe of despondency.",
    #     "The antique desk lamp, with its worn-out appearance, evokes quiet sorrow.",
    #     "The vintage lamp in the quiet room carries a sense of melancholy.",
    #     "The lonely attic lamp, with its feeble glow, adds to the desolation.",
    #     "The dim light of the old hallway lamp makes me feel a bit blue.",
    #     "The tarnished nightstand lamp fills me with a sense of quiet sorrow.",
    #     "The flickering flame of the vintage desk lamp creates loneliness.",
    #     "The neglected lamp in the corner brings a touch of sadness.",
    #     "The antique lamp, with its fading light, imparts despondency.",
    #     "The dusty lampshade on the forgotten lamp makes me feel downhearted.",
    #     "The worn-out appearance of the vintage desk lamp evokes quiet sorrow.",
    #     "The lonely room lamp, with its dim glow, carries a sense of melancholy.",
    #     "The aged shelf lamp, with its feeble light, adds to the desolation.",
    #     "A photo of a solitary lamp exudes desolation",
    #     "A photo of a vintage lamp brings forth quiet sorrow",
    #     "A photo of an antique lamp emanates a melancholy vibe",
    #     "A photo of a dusty lamp on a table evokes sadness",
    #     "A photo of a dimly lit lampshade imparts downheartedness",
    #     "A photo of an aged lamp with a flickering flame gives off despondency",
    #     "A photo of a vintage desk lamp, worn-out in appearance, evokes quiet sorrow",
    #     "A photo of a lonely room lamp carries a sense of melancholy",
    #     "A photo of an attic lamp with a feeble glow adds to the desolation",
    #     "A photo of the dim light of an old hallway lamp makes one feel a bit blue",
    #     "A photo of a tarnished nightstand lamp fills the viewer with quiet sorrow",
    #     "A photo of the flickering flame of a vintage desk lamp creates a lonely ambiance",
    #     "A photo of a neglected lamp in the corner brings a touch of sadness",
    #     "A photo of an antique lamp with fading light imparts despondency",
    #     "A photo of a worn-out vintage desk lamp evokes quiet sorrow",
    #     "A photo of a lonely room lamp with a dim glow carries a sense of melancholy",
    #     "A photo of an aged shelf lamp adds to the desolation",
    #     "A photo of a vintage lamp in solitude captures desolation",
    #     "A photo of an antique lamp on a shelf emanates melancholy",
    #     "A photo of a dusty lamp on a table evokes sadness",
    #     "The weary lamp in the attic radiates a feeling of desolation",
    #     "The dim glow of the vintage lamp in the hallway makes me a bit blue",
    #     "The flickering flame of the antique desk lamp creates a sense of loneliness",
    #     "The vintage lamp on the nightstand, with its faded light, imparts quiet sorrow",
    #     "The solitary lamp in the room, with its feeble glow, evokes melancholy",
    #     "The dusty lampshade on the forgotten lamp adds to a sense of downheartedness",
    #     "The antique desk lamp, with its aged appearance, brings a feeling of despondency",
    #     "The vintage lamp in the quiet room carries a subtle touch of sadness",
    #     "The lonely attic lamp, with its faint light, contributes to the desolation",
    #     "The dim light of the old hallway lamp makes me feel a touch blue",
    #     "The tarnished nightstand lamp emits a sense of quiet sorrow",
    #     "The flickering flame of the vintage desk lamp evokes a lonely ambiance",
    #     "The neglected lamp in the corner fills me with a feeling of sadness", 
    #     "The antique lamp, with its fading light, imparts a sense of desolation",
    #     "The dusty lampshade on the forgotten lamp brings downheartedness",
    #     "The worn-out appearance of the vintage desk lamp evokes quiet sorrow",
    #     "The lonely room lamp, with its dim glow, carries a hint of melancholy",
    #     "The aged shelf lamp, with its feeble light, contributes to the desolation",
    #     "The tired lamp in the attic radiates a feeling of despondency",
    #     "The dim glow of the vintage lamp in the hallway imparts a touch of sadness",
    #     "The flickering flame of the antique desk lamp creates a sense of downheartedness",
    #     "The vintage lamp on the nightstand, with its faded light, evokes a feeling of melancholy",
    #     "The solitary lamp in the room, with its feeble glow, imparts a subtle sense of loneliness",
    #     "The dusty lampshade on the forgotten lamp adds to a sense of desolation",
    #     "The antique desk lamp, with its aged appearance, brings a touch of sadness",
    #     "The vintage lamp in the quiet room carries a feeling of despondency",
    #     "The lonely attic lamp, with its faint light, contributes to a sense of melancholy",
    #     "The dim light of the old hallway lamp makes me feel downhearted",
    #     "The tarnished nightstand lamp emits a sense of quiet sorrow",
    #     "The flickering flame of the vintage desk lamp evokes a subtle touch of loneliness",
    #     "The neglected lamp in the corner brings forth a sense of desolation",
    #     "The antique lamp, with its fading light, imparts a feeling of melancholy",
    #     "The vintage lamp on the nightstand, with its dim glow, carries a touch of sadness",
    #     "The dusty lampshade on the forgotten lamp adds to a sense of despondency",
    #     "The aged shelf lamp, with its feeble light, contributes to the desolation",
    #     "The tired lamp in the attic radiates a subtle feeling of loneliness",
    #     "The dim glow of the vintage lamp in the hallway makes me feel downhearted",
    #     "The flickering flame of the antique desk lamp creates a sense of quiet sorrow",
    #     "The vintage lamp in the quiet room, with its faded light, evokes melancholy",
    #     "The solitary attic lamp, with its faint glow, imparts a touch of sadness",
    #     "The dim light of the old hallway lamp brings forth a sense of despondency",
    #     "The tarnished nightstand lamp, with its aged appearance, adds to the melancholy",
    #     "The flickering flame of the vintage desk lamp evokes a feeling of downheartedness",
    #     "The dusty lampshade on the forgotten lamp emits a sense of quiet sorrow",
    #     "The antique desk lamp, with its worn-out appearance, contributes to the desolation",
    #     "The vintage lamp in the quiet room brings forth a sense of loneliness",
    #     "The lonely attic lamp, with its dim glow, imparts a touch of sadness",
    #     "The aged shelf lamp, with its feeble light, adds to the desolation",
    #     "The dim glow of the vintage lamp in the hallway creates a feeling of quiet sorrow",
    #     "The neglected lamp in the corner, with its fading light, evokes a subtle sense of despondency",
    #     "The antique lamp on the nightstand carries a feeling of melancholy",
    #     "The dusty lampshade on the forgotten lamp, with its dim glow, brings forth a touch of sadness",
    #     "The vintage lamp in the quiet room adds to the sense of desolation",
    #     "The tired lamp in the attic, with its faint glow, imparts a subtle feeling of loneliness",
    #     "The dim light of the old hallway lamp makes me feel downhearted",
    #     "The flickering flame of the antique desk lamp brings forth a sense of quiet sorrow",
    #     "The vintage lamp on the nightstand, with its aged appearance, adds to the despondency",
    #     "The dusty lampshade on the forgotten lamp emits a touch of melancholy",
    #     "The aged shelf lamp, with its dim glow, contributes to the desolation",
    #     "The solitary attic lamp, with its feeble light, brings forth a feeling of loneliness",
    # ]
    
    # sentences_dog_10= [
    #     "A picture of a forlorn dog.",
    #     "An image of a despondent dog.",
    #     "A snapshot of a melancholic dog.",
    #     "A photo capturing a gloomy dog.",
    #     "An illustration of a reflective and grief-stricken dog.",
    #     "A picture of a dog with a wistful and sorrowful gaze.",
    #     "A photograph of a contemplative dog lost in thought.",
    #     "An image portraying a reflective and troubled dog.",
    #     "A scene showing a reflective and dolorous dog's pensive demeanor.",
    #     "An illustration of a contemplative and heart-rending dog's gaze.",
    #     "A picture of a threatening dog.",
    #     "An image of a hostile dog.",
    #     "A snapshot of a fierce dog.",
    #     "A photo capturing a menacing dog.",
    #     "A visual of an aggressive and threatening dog.",
    #     "An image capturing a fierce and snarling dog.",
    #     "A depiction of a vicious and hostile dog.",
    #     "A portrayal of an intimidating and ferocious dog.",
    #     "A glimpse of an aggressive and ferocious dog.",
    #     "An image capturing a threatening and unfriendly dog.",
    #     "A picture of an abandoned dog.",
    #     "An image of a solitary dog.",
    #     "A photo of a desolate dog.",
    #     "A snapshot of a forlorn dog.",
    #     "A portrayal of a forgotten and isolated dog.",
    #     "An illustration of a discarded and lonely dog.",
    #     "An image of a forsaken and abandoned dog.",
    #     "A photo of a lonesome and rejected dog.",
    #     "A portrayal of an isolated and forsaken dog.",
    #     "An illustration of a desolate and discarded dog."
    # ]
    
    # sentences_dog_20= [
    #     "A picture of a forlorn dog.",
    #     "An image of a despondent dog.",
    #     "A snapshot of a melancholic dog.",
    #     "A photo capturing a gloomy dog.",
    #     "An illustration of a reflective and grief-stricken dog.",
    #     "A picture of a dog with a wistful and sorrowful gaze.",
    #     "A photograph of a contemplative dog lost in thought.",
    #     "An image portraying a reflective and troubled dog.",
    #     "A scene showing a reflective and dolorous dog's pensive demeanor.",
    #     "An illustration of a contemplative and heart-rending dog's gaze.",
    #     "A picture of a threatening dog.",
    #     "An image of a hostile dog.",
    #     "A snapshot of a fierce dog.",
    #     "A photo capturing a menacing dog.",
    #     "A visual of an aggressive and threatening dog.",
    #     "An image capturing a fierce and snarling dog.",
    #     "A depiction of a vicious and hostile dog.",
    #     "A portrayal of an intimidating and ferocious dog.",
    #     "A glimpse of an aggressive and ferocious dog.",
    #     "An image capturing a threatening and unfriendly dog.",
    #     "A picture of an abandoned dog.",
    #     "An image of a solitary dog.",
    #     "A photo of a desolate dog.",
    #     "A snapshot of a forlorn dog.",
    #     "A portrayal of a forgotten and isolated dog.",
    #     "An illustration of a discarded and lonely dog.",
    #     "An image of a forsaken and abandoned dog.",
    #     "A photo of a lonesome and rejected dog.",
    #     "A portrayal of an isolated and forsaken dog.",
    #     "An illustration of a desolate and discarded dog."
    #     "A portrayal of a dejected dog.",
    #     "An illustration of a downcast dog.",
    #     "A painting of a crestfallen dog.",
    #     "A sketch of a disheartened dog.",
    #     "A depiction of a saddened dog.",
    #     "An image portraying a profoundly saddened dog.",
    #     "A visual of a mournful and desolate dog.",
    #     "A snapshot of a pensive and melancholic dog.",
    #     "An illustration capturing the sorrow of a dog.",
    #     "A painting reflecting the wistfulness of a dog.",
    #     "A visual of a hostile and menacing dog.",
    #     "A glimpse of a threatening and fierce dog.",
    #     "A view of a dangerous and unfriendly dog.",
    #     "A snapshot of a ferocious and aggressive dog.",
    #     "A scene showing a menacing and snarling dog.",
    #     "An illustration of an intimidating and vicious dog.",
    #     "A picture of a menacing and aggressive dog.",
    #     "A snapshot of a threatening and menacing dog.",
    #     "A scene showing a hostile and fierce dog.",
    #     "A photo of a snarling and intimidating dog.",
    #     "A photo of a forsaken and discarded dog.",
    #     "A portrayal of a neglected and forgotten dog.",
    #     "An illustration of a desolate and abandoned dog.",
    #     "A painting of a lonesome and forsaken dog.",
    #     "A sketch of a forgotten and isolated dog.",
    #     "An artwork of a discarded and lonesome dog.",
    #     "A drawing of a forsaken and rejected dog.",
    #     "A visual of a neglected and desolate dog.", 
    #     "A glimpse of an abandoned and forsaken dog.",
    #     "A scene showing a lonesome and discarded dog."
    # ]
    
    # sentences_dog_50 = [
    #     "A picture of a forlorn dog.",
    #     "An image of a despondent dog.",
    #     "A snapshot of a melancholic dog.",
    #     "A photo capturing a gloomy dog.",
    #     "An illustration of a reflective and grief-stricken dog.",
    #     "A picture of a dog with a wistful and sorrowful gaze.",
    #     "A photograph of a contemplative dog lost in thought.",
    #     "An image portraying a reflective and troubled dog.",
    #     "A scene showing a reflective and dolorous dog's pensive demeanor.",
    #     "An illustration of a contemplative and heart-rending dog's gaze.",
    #     "A picture of a threatening dog.",
    #     "An image of a hostile dog.",
    #     "A snapshot of a fierce dog.",
    #     "A photo capturing a menacing dog.",
    #     "A visual of an aggressive and threatening dog.",
    #     "An image capturing a fierce and snarling dog.",
    #     "A depiction of a vicious and hostile dog.",
    #     "A portrayal of an intimidating and ferocious dog.",
    #     "A glimpse of an aggressive and ferocious dog.",
    #     "An image capturing a threatening and unfriendly dog.",
    #     "A picture of an abandoned dog.",
    #     "An image of a solitary dog.",
    #     "A photo of a desolate dog.",
    #     "A snapshot of a forlorn dog.",
    #     "A portrayal of a forgotten and isolated dog.",
    #     "An illustration of a discarded and lonely dog.",
    #     "An image of a forsaken and abandoned dog.",
    #     "A photo of a lonesome and rejected dog.",
    #     "A portrayal of an isolated and forsaken dog.",
    #     "An illustration of a desolate and discarded dog."
    #     "A portrayal of a dejected dog.",
    #     "An illustration of a downcast dog.",
    #     "A painting of a crestfallen dog.",
    #     "A sketch of a disheartened dog.",
    #     "A depiction of a saddened dog.",
    #     "An image portraying a profoundly saddened dog.",
    #     "A visual of a mournful and desolate dog.",
    #     "A snapshot of a pensive and melancholic dog.",
    #     "An illustration capturing the sorrow of a dog.",
    #     "A painting reflecting the wistfulness of a dog.",
    #     "A visual of a hostile and menacing dog.",
    #     "A glimpse of a threatening and fierce dog.",
    #     "A view of a dangerous and unfriendly dog.",
    #     "A snapshot of a ferocious and aggressive dog.",
    #     "A scene showing a menacing and snarling dog.",
    #     "An illustration of an intimidating and vicious dog.",
    #     "A picture of a menacing and aggressive dog.",
    #     "A snapshot of a threatening and menacing dog.",
    #     "A scene showing a hostile and fierce dog.",
    #     "A photo of a snarling and intimidating dog.",
    #     "A photo of a forsaken and discarded dog.",
    #     "A portrayal of a neglected and forgotten dog.",
    #     "An illustration of a desolate and abandoned dog.",
    #     "A painting of a lonesome and forsaken dog.",
    #     "A sketch of a forgotten and isolated dog.",
    #     "An artwork of a discarded and lonesome dog.",
    #     "A drawing of a forsaken and rejected dog.",
    #     "A visual of a neglected and desolate dog.", 
    #     "A glimpse of an abandoned and forsaken dog.",
    #     "A scene showing a lonesome and discarded dog.",
    #     "An artwork showing a mournful dog.",
    #     "A drawing of a wistful dog.",
    #     "A visual of a doleful dog.",
    #     "A representation of a sorrowful dog.",
    #     "A scene of a dismal dog.",
    #     "A glimpse of a desolate dog.",
    #     "A view of a woeful dog.",
    #     "A capture of a heartbroken dog.",
    #     "A view of a mournful dog.",
    #     "An illustration of a despairing dog.",
    #     "A snapshot of a lugubrious dog.",
    #     "A photograph of a somber dog.",
    #     "An image portraying a woebegone dog.",
    #     "A visual of a troubled dog.",
    #     "A snapshot of a pensive dog.",
    #     "An illustration capturing a mournful dog.",
    #     "A painting reflecting a doleful dog.",
    #     "A sketch revealing a heartrending dog.",
    #     "A depiction of a downhearted dog.",
    #     "A portrayal of a lamenting dog.",
    #     "An artwork depicting a rueful dog.",
    #     "A drawing conveying a downcast dog.",
    #     "A portrayal of a disconsolate dog.",
    #     "An image capturing a sorrow-laden dog.",
    #     "A visual of a melancholy dog.",
    #     "A glimpse of a crestfallen dog.",
    #     "A view of a grief-stricken dog.",
    #     "A snapshot of a heavy-hearted dog.",
    #     "A scene showing a dolorous dog.",
    #     "An illustration of a heart-rending dog.",
    #     "An illustration of an intimidating and vicious dog.",
    #     "A portrayal of a hostile and dangerous dog.",
    #     "A picture of an aggressive and unfriendly dog.",
    #     "A photo capturing a menacing and ferocious dog.",
    #     "A photograph of a menacing and hostile dog.",
    #     "An image capturing an aggressive and dangerous dog.",
    #     "A visual of a threatening and fierce dog.",
    #     "A depiction of a snarling and vicious dog.",
    #     "A portrayal of a ferocious and intimidating dog.",
    #     "An illustration of a hostile and unfriendly dog.",
    #     "A picture of a dangerous and menacing dog.",
    #     "A snapshot of a fierce and aggressive dog.",
    #     "A scene showing an intimidating and hostile dog.",
    #     "A photo of a menacing and dangerous dog.",
    #     "A visual of an aggressive and threatening dog.",
    #     "An image capturing a fierce and snarling dog.",
    #     "A depiction of a vicious and hostile dog.",
    #     "A portrayal of an intimidating and ferocious dog.",
    #     "An illustration of a dangerous and aggressive dog.",
    #     "A snapshot of a menacing and intimidating dog.",
    #     "A picture of a hostile and snarling dog.",
    #     "A photograph of a threatening and vicious dog.",
    #     "A view of a dangerous and ferocious dog.",
    #     "A scene showing an aggressive and unfriendly dog.",
    #     "A glimpse of a menacing and hostile dog.",
    #     "A photo capturing a threatening and fierce dog.",
    #     "An image of a snarling and dangerous dog.",
    #     "A visual of a ferocious and menacing dog.",
    #     "A depiction of an aggressive and intimidating dog.",
    #     "A portrayal of a vicious and unfriendly dog.",
    #     "A painting of a forsaken and neglected dog.",
    #     "A sketch of a solitary and abandoned dog.",
    #     "An artwork of a lonesome and rejected dog.",
    #     "A drawing of an isolated and desolate dog.",
    #     "A visual of a discarded and forlorn dog.",
    #     "A glimpse of a neglected and forsaken dog.",
    #     "A scene showing a desolate and solitary dog.",
    #     "A view of a forgotten and rejected dog.",
    #     "A photograph of an abandoned and isolated dog.",
    #     "A portrayal of a lonesome and discarded dog.",
    #     "An illustration of a forsaken and neglected dog.",
    #     "A picture of a solitary and forsaken dog.",
    #     "A depiction of a neglected and desolate dog.",
    #     "A snapshot of a forgotten and abandoned dog.",
    #     "An image of a discarded and lonesome dog.",
    #     "A photo of an isolated and rejected dog.",
    #     "A portrayal of a desolate and forsaken dog.",
    #     "An illustration of a lonely and neglected dog.",
    #     "A painting of a forgotten and forlorn dog.",
    #     "A sketch of an abandoned and solitary dog.",
    #     "An artwork of a lonesome and rejected dog.",
    #     "A drawing of an isolated and discarded dog.",
    #     "A visual of a forsaken and neglected dog.",
    #     "A glimpse of a discarded and lonely dog.",
    #     "A scene showing a neglected and abandoned dog.",
    #     "A view of a desolate and rejected dog.",
    #     "A photograph of a forgotten and isolated dog.",
    #     "A portrayal of a forsaken and discarded dog.",
    #     "An illustration of a lonesome and forsaken dog.",
    #     "A picture of a neglected and solitary dog."    
    # ]
    
    # sentences_dog_sad_10 = [
    #     "A picture of a forlorn dog.",
    #     "An image of a despondent dog.",
    #     "A snapshot of a melancholic dog.",
    #     "A photo capturing a gloomy dog.",
    #     "An illustration of a reflective and grief-stricken dog.",
    #     "A picture of a dog with a wistful and sorrowful gaze.",
    #     "A photograph of a contemplative dog lost in thought.",
    #     "An image portraying a reflective and troubled dog.",
    #     "A scene showing a reflective and dolorous dog's pensive demeanor.",
    #     "An illustration of a contemplative and heart-rending dog's gaze."
    # ]
    
    # sentences_dog_sad_20 = [
    #     "A picture of a forlorn dog.",
    #     "An image of a despondent dog.",
    #     "A snapshot of a melancholic dog.",
    #     "A photo capturing a gloomy dog.",
    #     "An illustration of a reflective and grief-stricken dog.",
    #     "A picture of a dog with a wistful and sorrowful gaze.",
    #     "A photograph of a contemplative dog lost in thought.",
    #     "An image portraying a reflective and troubled dog.",
    #     "A scene showing a reflective and dolorous dog's pensive demeanor.",
    #     "An illustration of a contemplative and heart-rending dog's gaze."
    #     "A portrayal of a dejected dog.",
    #     "An illustration of a downcast dog.",
    #     "A painting of a crestfallen dog.",
    #     "A sketch of a disheartened dog.",
    #     "A depiction of a saddened dog.",
    #     "An image portraying a profoundly saddened dog.",
    #     "A visual of a mournful and desolate dog.",
    #     "A snapshot of a pensive and melancholic dog.",
    #     "An illustration capturing the sorrow of a dog.",
    #     "A painting reflecting the wistfulness of a dog."
    # ]
    
    # sentences_dog_sad_50 = [
    #     "A picture of a forlorn dog.",
    #     "An image of a despondent dog.",
    #     "A snapshot of a melancholic dog.",
    #     "A photo capturing a gloomy dog.",
    #     "An illustration of a reflective and grief-stricken dog.",
    #     "A picture of a dog with a wistful and sorrowful gaze.",
    #     "A photograph of a contemplative dog lost in thought.",
    #     "An image portraying a reflective and troubled dog.",
    #     "A scene showing a reflective and dolorous dog's pensive demeanor.",
    #     "An illustration of a contemplative and heart-rending dog's gaze."
    #     "A portrayal of a dejected dog.",
    #     "An illustration of a downcast dog.",
    #     "A painting of a crestfallen dog.",
    #     "A sketch of a disheartened dog.",
    #     "A depiction of a saddened dog.",
    #     "An image portraying a profoundly saddened dog.",
    #     "A visual of a mournful and desolate dog.",
    #     "A snapshot of a pensive and melancholic dog.",
    #     "An illustration capturing the sorrow of a dog.",
    #     "A painting reflecting the wistfulness of a dog.",
    #     "An artwork showing a mournful dog.",
    #     "A drawing of a wistful dog.",
    #     "A visual of a doleful dog.",
    #     "A representation of a sorrowful dog.",
    #     "A scene of a dismal dog.",
    #     "A glimpse of a desolate dog.",
    #     "A view of a woeful dog.",
    #     "A capture of a heartbroken dog.",
    #     "A view of a mournful dog.",
    #     "An illustration of a despairing dog.",
    #     "A snapshot of a lugubrious dog.",
    #     "A photograph of a somber dog.",
    #     "An image portraying a woebegone dog.",
    #     "A visual of a troubled dog.",
    #     "A snapshot of a pensive dog.",
    #     "An illustration capturing a mournful dog.",
    #     "A painting reflecting a doleful dog.",
    #     "A sketch revealing a heartrending dog.",
    #     "A depiction of a downhearted dog.",
    #     "A portrayal of a lamenting dog.",
    #     "An artwork depicting a rueful dog.",
    #     "A drawing conveying a downcast dog.",
    #     "A portrayal of a disconsolate dog.",
    #     "An image capturing a sorrow-laden dog.",
    #     "A visual of a melancholy dog.",
    #     "A glimpse of a crestfallen dog.",
    #     "A view of a grief-stricken dog.",
    #     "A snapshot of a heavy-hearted dog.",
    #     "A scene showing a dolorous dog.",
    #     "An illustration of a heart-rending dog."
    # ]
    
    # sentences_dog_sad_100 = [
    #     "A picture of a forlorn dog.", #
    #     "An image of a despondent dog.", #
    #     "A snapshot of a melancholic dog.", #
    #     "A photo capturing a gloomy dog.", #
    #     "A portrayal of a dejected dog.", #
    #     "An illustration of a downcast dog.", #
    #     "A painting of a crestfallen dog.",#
    #     "A sketch of a disheartened dog.",#
    #     "A depiction of a saddened dog.", #
    #     "An artwork showing a mournful dog.",
    #     "A drawing of a wistful dog.",
    #     "A visual of a doleful dog.",
    #     "A representation of a sorrowful dog.",
    #     "A scene of a dismal dog.",
    #     "A glimpse of a desolate dog.",
    #     "A view of a woeful dog.",
    #     "A capture of a heartbroken dog.",
    #     "A view of a mournful dog.",
    #     "An illustration of a despairing dog.",
    #     "A snapshot of a lugubrious dog.",
    #     "A photograph of a somber dog.",
    #     "An image portraying a woebegone dog.",
    #     "A visual of a troubled dog.",
    #     "A snapshot of a pensive dog.",
    #     "An illustration capturing a mournful dog.",
    #     "A painting reflecting a doleful dog.",
    #     "A sketch revealing a heartrending dog.",
    #     "A depiction of a downhearted dog.",
    #     "A portrayal of a lamenting dog.",
    #     "An artwork depicting a rueful dog.",
    #     "A drawing conveying a downcast dog.",
    #     "A portrayal of a disconsolate dog.",
    #     "An image capturing a sorrow-laden dog.",
    #     "A visual of a melancholy dog.",
    #     "A glimpse of a crestfallen dog.",
    #     "A view of a grief-stricken dog.",
    #     "A snapshot of a heavy-hearted dog.",
    #     "A scene showing a dolorous dog.",
    #     "An illustration of a heart-rending dog.",
    #     "A picture of a troubled and somber dog.",
    #     "A photograph of a dog with a heavy heart.",
    #     "An image portraying a profoundly saddened dog.", #
    #     "A visual of a mournful and desolate dog.",#
    #     "A snapshot of a pensive and melancholic dog.",#
    #     "An illustration capturing the sorrow of a dog.",#
    #     "A painting reflecting the wistfulness of a dog.",#
    #     "A sketch revealing a world-weary dog.",
    #     "A depiction of a reflective and despondent dog.",
    #     "A portrayal of a soulful and dejected dog.",
    #     "An artwork depicting the heavy-heartedness of a dog.",
    #     "A drawing conveying the melancholy of a dog's gaze.",
    #     "A portrayal of the heavy-hearted and contemplative dog.",
    #     "An image capturing the reflective and sorrowful dog.",
    #     "A visual of a contemplative and mournful dog.",
    #     "A glimpse of a reflective and downcast dog.",
    #     "A view of a contemplative and disconsolate dog.",
    #     "A snapshot of a pensive and heartbroken dog.",
    #     "A scene showing a wistful and desolate dog.",
    #     "An illustration of a reflective and grief-stricken dog.", #
    #     "A picture of a dog with a wistful and sorrowful gaze.", #
    #     "A photograph of a contemplative dog lost in thought.", #
    #     "An image portraying a reflective and troubled dog.", #
    #     "A visual of a contemplative and troubled dog's expression.",
    #     "A snapshot of a pensive dog, lost in introspection.",
    #     "An illustration capturing a dog's contemplative sadness.",
    #     "A painting reflecting a sorrowful and contemplative dog.",
    #     "A sketch revealing a dog's pensive and melancholic state.",
    #     "A depiction of a reflective and dejected dog's expression.",
    #     "A portrayal of a contemplative and sorrow-laden dog.",
    #     "An artwork depicting a pensive and melancholy dog's gaze.",
    #     "A drawing conveying the heavy-heartedness of a contemplative dog.",
    #     "A portrayal of a pensive and downcast dog's demeanor.",
    #     "An image capturing the contemplative and despondent dog's gaze.",
    #     "A visual of a reflective and crestfallen dog's expression.",
    #     "A glimpse of a sorrowful and disconsolate dog's demeanor.",
    #     "A view of a pensive and heartbroken dog's gaze.",
    #     "A snapshot of a contemplative and dolorous dog's expression.",
    #     "A scene showing a reflective and heart-rending dog's state.",
    #     "An illustration of a contemplative and grief-stricken dog's gaze.",
    #     "A picture of a pensive and troubled dog, lost in thought.",
    #     "A photograph of a reflective and mournful dog's demeanor.",
    #     "An image portraying a contemplative and desolate dog's expression.",
    #     "A visual of a pensive and melancholic dog's forlorn gaze.",
    #     "A snapshot of a reflective and sorrowful dog, lost in introspection.",
    #     "An illustration capturing a contemplative and wistful dog's state.",
    #     "A painting reflecting a dog's reflective and troubled demeanor.",
    #     "A sketch revealing a pensive and dejected dog's melancholic gaze.",
    #     "A depiction of a reflective and sorrow-laden dog's contemplation.",
    #     "A portrayal of a contemplative and heavy-hearted dog's expression.",
    #     "An artwork depicting a pensive and crestfallen dog's demeanor.",
    #     "A drawing conveying the melancholy of a reflective dog's gaze.",
    #     "A portrayal of the contemplative and downcast dog's expression.",
    #     "An image capturing the reflective and despondent dog's demeanor.",
    #     "A visual of a contemplative and grief-stricken dog's pensive gaze.",
    #     "A glimpse of a sorrowful and troubled dog's contemplative state.",
    #     "A view of a pensive and disconsolate dog's reflective gaze.",
    #     "A snapshot of a contemplative and heartbroken dog's expression.",
    #     "A scene showing a reflective and dolorous dog's pensive demeanor.", #
    #     "An illustration of a contemplative and heart-rending dog's gaze.", #
    #     "A picture of a pensive and desolate dog, reflecting on loss."
    # ]
    
    # sentences_dog_2_mood = [
    #  "A picture of a forlorn dog.",
    #  "An image of a despondent dog.",
    #  "A snapshot of a melancholic dog.",
    #  "A photo capturing a gloomy dog.",
    #  "An illustration of a reflective and grief-stricken dog.",
    #  "A picture of a dog with a wistful and sorrowful gaze.",
    #  "A photograph of a contemplative dog lost in thought.",
    #  "An image portraying a reflective and troubled dog.",
    #  "A scene showing a reflective and dolorous dog's pensive demeanor.",
    #  "An illustration of a contemplative and heart-rending dog's gaze."
    #  "A picture of a threatening dog.", #
    #  "An image of a hostile dog.", #
    #  "A snapshot of a fierce dog.", #
    #  "A photo capturing a menacing dog.", #
    #  "A visual of an aggressive and threatening dog.",
    #  "An image capturing a fierce and snarling dog.",
    #  "A depiction of a vicious and hostile dog.",
    #  "A portrayal of an intimidating and ferocious dog.",
    #  "A photograph of a threatening and vicious dog.",
    #  "A view of a dangerous and ferocious dog."
    # ]
    
    # sentences_dog_3_mood = [
    #  "A picture of a forlorn dog.",
    #  "An image of a despondent dog.",
    #  "A snapshot of a melancholic dog.",
    #  "A photo capturing a gloomy dog.",
    #  "An illustration of a reflective and grief-stricken dog.",
    #  "A picture of a dog with a wistful and sorrowful gaze.",
    #  "A photograph of a contemplative dog lost in thought.",
    #  "An image portraying a reflective and troubled dog.",
    #  "A scene showing a reflective and dolorous dog's pensive demeanor.",
    #  "An illustration of a contemplative and heart-rending dog's gaze."
    #  "A picture of a threatening dog.", #
    #  "An image of a hostile dog.", #
    #  "A snapshot of a fierce dog.", #
    #  "A photo capturing a menacing dog.", #
    #  "A visual of an aggressive and threatening dog.",
    #  "An image capturing a fierce and snarling dog.",
    #  "A depiction of a vicious and hostile dog.",
    #  "A portrayal of an intimidating and ferocious dog.",
    #  "A photograph of a threatening and vicious dog.",
    #  "A view of a dangerous and ferocious dog.",
    #  "A picture of an abandoned dog.",
    #  "An image of a solitary dog.",
    #  "A photo of a desolate dog.",
    #  "A snapshot of a forlorn dog.",
    #  "A portrayal of a forgotten and isolated dog.",
    #  "An illustration of a discarded and lonely dog.",
    #  "An image of a forsaken and abandoned dog.",
    #  "A photo of a lonesome and rejected dog.",
    #  "A portrayal of an isolated and forsaken dog.",
    #  "An illustration of a desolate and discarded dog."    
    # ]
    
    # sentences_dog_4_mood = [
    # "A picture of a forlorn dog.",
    # "An image of a despondent dog.",
    # "A snapshot of a melancholic dog.",
    # "A photo capturing a gloomy dog.",
    # "An illustration of a reflective and grief-stricken dog.",
    # "A picture of a dog with a wistful and sorrowful gaze.",
    # "A photograph of a contemplative dog lost in thought.",
    # "An image portraying a reflective and troubled dog.",
    # "A scene showing a reflective and dolorous dog's pensive demeanor.",
    # "An illustration of a contemplative and heart-rending dog's gaze."
    # "A picture of a threatening dog.", #
    # "An image of a hostile dog.", #
    # "A snapshot of a fierce dog.", #
    # "A photo capturing a menacing dog.", #
    # "A visual of an aggressive and threatening dog.",
    # "An image capturing a fierce and snarling dog.",
    # "A depiction of a vicious and hostile dog.",
    # "A portrayal of an intimidating and ferocious dog.",
    # "A photograph of a threatening and vicious dog.",
    # "A view of a dangerous and ferocious dog.",
    # "A picture of an abandoned dog.",
    # "An image of a solitary dog.",
    # "A photo of a desolate dog.",
    # "A snapshot of a forlorn dog.",
    # "A portrayal of a forgotten and isolated dog.",
    # "An illustration of a discarded and lonely dog.",
    # "An image of a forsaken and abandoned dog.",
    # "A photo of a lonesome and rejected dog.",
    # "A portrayal of an isolated and forsaken dog.",
    # "An illustration of a desolate and discarded dog.", 
    # "A photo of an anxious dog nervously pacing around the room",
    # "A snapshot capturing a worried dog with a furrowed brow",
    # "A painting of an uneasy dog, displaying signs of restlessness",
    # "An illustration of a dog exhibiting anxious behavior in a thunderstorm",
    # "A scene showing an apprehensive dog seeking comfort in a corner",
    # "A view of a fretful dog, its ears flattened and tail tucked anxiously",
    # "A glimpse of a distressed dog, nervously scanning its surroundings",
    # "A visual of an agitated dog, exhibiting signs of separation anxiety",
    # "An artwork depicting a jittery dog struggling with social anxiety",
    # "A drawing of a canine companion displaying signs of anxious anticipation"
    # ]
        
    sentences_token = clip.tokenize(sentences_dog_100).to(device)
    sentences_embeddings = clip_model.encode_text(sentences_token)
    
   
    original_embeddings_filename = '/model/CapDec-main/original_embeddings.txt'
    np.savetxt(original_embeddings_filename, sentences_embeddings.cpu().detach().numpy())

    
   
    num_clusters = 3
    
    
    with torch.no_grad():
        kmeans_model = KMeans(n_clusters=num_clusters)
        kmeans_model.fit(sentences_embeddings.cpu().numpy())
        cluster_centers = kmeans_model.cluster_centers_
      
        print(cluster_centers.shape)
        
      
        cluster1 = cluster_centers[0]
        cluster2 = cluster_centers[1]
        cluster3 = cluster_centers[2]


       
        # separate_clusters = [cluster1, cluster2, cluster3,cluster4]
        separate_clusters = [cluster1, cluster2, cluster3]

 
        std_dev = 0.2


        new_embeddings = []

        for center in separate_clusters:
            for _ in range(10):
                perturbation = np.random.normal(scale=std_dev, size=center.shape)
                new_embedding = center + perturbation
                new_embeddings.append(new_embedding)

        new_embeddings = np.array(new_embeddings)
        print(new_embeddings)
        print(new_embeddings.shape)
        # output_filename = '/model/CapDec-main/new_embeddings.txt'
        # np.savetxt(output_filename, new_embeddings)

   

    results=[]
    for i in range(len(new_embeddings)):
        given_embedding = new_embeddings[i]
        given_embedding = torch.from_numpy(given_embedding)
        given_embedding = given_embedding.to(device)
        given_embedding = given_embedding.float()
        given_embedding = given_embedding.unsqueeze(0)
        make_preds(model, out_path, tokenizer, results, given_prefix=given_embedding, args=args)
    
    print(results)
    # output_results_filename = '/model/CapDec-main/generated_sentences.txt'
    # with open(output_results_filename, 'w') as file:
    #     for sentence in results:
    #         file.write(sentence + '\n')
    # make_preds_test(model, out_path, tokenizer, clip_model=clip_model, args=args)

if __name__ == '__main__':
    main()