# Beach Graphon MFG Solver Comparison

This repository contains code for comparing different solvers (RMD, APP, Proximal) on the Beach Graphon Mean Field Game (MFG) problem.

## Project Overview

This project implements and compares three different solvers for Mean Field Games:
- Regularized Mirror Descent (RMD)
- Approximate Proximal Point (APP)
- Proximal Solver

The experiments focus on comparing the performance of these solvers on the Beach Graphon MFG problem with η=0.1.

## Installation

### Requirements

- Python 3.11+
- Poetry (for dependency management)

### Setup

1. Clone this repository
2. Install dependencies using Poetry:

```bash
poetry install
```

## Running the Experiments

To run the Beach Graphon experiment with the default parameters:

```bash
poetry run python -m experiments.test_beach_graphon_submit
```

### Parameters

You can modify the following parameters:
- `--eta`: Learning rate (default: 0.1)
- `--horizon`: Time horizon (default: 3)
- `--iterations`: Number of iterations (default: 500)
- `--reg_param`: Regularization parameter (default: 0.4)

Example:

```bash
poetry run python -m experiments.test_beach_graphon_submit --eta 0.1 --horizon 3 --iterations 100
```

## Experiment Details

The experiment compares the performance of RMD, APP, and Proximal solvers on the Beach Graphon MFG problem. The performance is measured by the exploitability of the policies over iterations.

### Output

The experiment generates plots showing:
- Exploitability over iterations for each solver
- Final policies for each solver

Results are saved in the `results/` directory.
