#!/usr/bin/env python
# -*- coding: utf-8 -*-

import argparse
from experiments.test_beach_graphon_submit import test_beach_graphon_simplified

def main():
    parser = argparse.ArgumentParser(description="Run Beach Graphon MFG experiments")
    parser.add_argument('--iterations', type=int, default=100, help='Number of iterations (default: 100)')
    parser.add_argument('--tolerance', type=float, default=1e-4, help='Tolerance for early stopping in AdaptiveProxRMDSolver (default: 1e-4)')
    args = parser.parse_args()
    
    print(f"Running Beach Graphon MFG experiment with {args.iterations} iterations...")
    test_beach_graphon_simplified(args.iterations, args.tolerance)
    print("Experiment completed!")

if __name__ == "__main__":
    main()
