from collections import defaultdict
from typing import Dict
# Import abstract class
from abc import ABC, abstractmethod
from typing import Set

# Abstract class
class Tracker(ABC):

    @abstractmethod
    def update(self, src, dst, t):
        pass
    
    @abstractmethod
    def get_total(self, src):
        pass


    @abstractmethod
    def contains_dst(self, src, dst):
        """ Returns true if the dst node is considered observed for the tracker. """
        pass

    @abstractmethod
    def get_score(self, src, dst):
        """Should probably be renamed 'get_score' or similar. """
        pass

    @abstractmethod
    def get_tied_entities(self, src, dst, t):
        pass

    @abstractmethod
    def get_entities_to_filter_out(self, src, dst, t):
        pass

    @abstractmethod
    def get_rank(self, src, dst, current_t, to_filter : set = None):
        pass

    @abstractmethod
    def get_full_mrr(self, src, dst, t, to_filter : set = None):
        pass

    @abstractmethod
    def get_node_rank(self, src, dst, t):
        pass

    @abstractmethod
    def get_entities_to_filter_out(self, src, dst, t):
        pass


    @abstractmethod
    def tracker_score_type(self):
        pass

    def _get_tied_entities_within_set(self, src, dst, t, candidate_set : Set[int]):
        return {cand_dst for cand_dst in candidate_set if self.get_score(src, cand_dst) == self.get_score(src, dst) and cand_dst != dst}
    

    def get_rank_within_set(self, src, dst, set_of_dst : Set[int], current_t):
        # """Get rank of entity within a set of entities"""
        # assert self.contains_dst(None, dst), "Should not happen"
        # if not self.contains_dst(src, dst):
        #     return len(set_of_dst), len(set_of_dst)
        optimistic_rank = 0
        pessimistic_rank = 0

        

        for entity in set_of_dst:
            optimistic_rank += int(self.get_score(src, entity) > self.get_score(src, dst))
            pessimistic_rank += int(self.get_score(src, entity) >= self.get_score(src, dst))
            

        return optimistic_rank, pessimistic_rank