from collections import Counter
# Highly inspired (parts copied from) by https://www.geeksforgeeks.org/binary-indexed-tree-or-fenwick-tree-2/


class FenwickTree:
    def __init__(self, num_timestamps : int, sparse: bool = True):
        self.times = Counter() if sparse is True else [0 for _ in range(num_timestamps + 1)]
        self.n = num_timestamps

    def update(self, i, val):
        # index in BITree[] is 1 more than the index in arr[]
        i += 1

        # Traverse all ancestors and add 'val'
        while i <= self.n:

            # Add 'val' to current node of BI Tree
            self.times[i] += val

            # Update index to that of parent in update View
            i += i & (-i)
        
    def get_sum(self, i_):
        s = 0
        # index in BITree[] is 1 more than the index in arr[]
        i = i_+1
        # Traverse ancestors of BITree[index]
        while i > 0:
            # Add current element of BITree to sum
            s += self.times[i]
            
            # Move index to parent node in getSum View
            i -= i & (-i)
        return s