

/* ------------------------------------------------------------
Vector operations
-------------------------------------------------------------*/
//  Create a new vector of size n
double *new_vec(int n);
// Free the vector u
void free_vec(double *u);
// Make a vector u[n] zero
void vec_zero(double *u, int n);
// Copy a vector u[n] to v[n]
void vec_cpy(double *u, double *v, int n);
// Linear combination w = au + bv of vectors u and v
void vec_lincom(double *u, double *v, double a, double b, double *w, int n);
// Return the inner product of vectors u[n] and v[n]
double vec_innerprod(double *u, double *v, int n);
// Read a vector of size n from a file
double *vec_fread(FILE *fp, int n);
// Write a vector of size n to a file
void vec_fwrite(FILE *fp, double *u, int n);

/* ------------------------------------------------------------
Matrix operations
-------------------------------------------------------------*/
// Create a new matrix of size mXn
double **new_mat(int m, int n);
// Free the mXn matrix A
void free_mat(double **A, int m);
// Make a matrix A[m][n] zero
void mat_zero(double **A, int m, int n);
// Copy a matrix A[m][n] to B[m][n]
void mat_cpy(double **A, double **B, int m, int n);
// Compute the matrix-vector product Ax and store the result into y.
void mat_vec_mult(double **A, double *x, double *y, int m, int n);
// Solve the linear system Ax = b directly.
void mat_solve(double **A, double *b, double *x, int n);
// Solve the linear system PAx = Pb by the preconditioned conjugate gradient method.
void pcg(double **A, double *b, double **P, double *x, int n);
// Solve the tridiagonal linear system Ax = b by the Thomas' algorithm.
void mat_trisolve(double **A, double *b, double *x, int n);

/* ------------------------------------------------------------
Tensor operations
-------------------------------------------------------------*/
// Create a new tensor of size l X m X n
double ***new_ten(int l, int m, int n);
// Free the l X m X n tensor A
void free_ten(double ***A, int l, int m);