 #define ROOT 0

 // schwarz structure
typedef struct _schwarz_
{
	// MPI variables
	int nprocs, pid;
	// Neuron indices of each process determined by the para-range subroutine
	int *ista, *iend, *isize;
} schwarz;

// New schwarz structure
schwarz *new_schwarz(int n, int nprocs, int pid);
// Free schwarz structure
void free_schwarz(schwarz *sc);

// Train the neural network by NPSC
double train_NPSC(shallow_nn *nn, double *c, double *theta, schwarz *sc, int num_epochs, double *E_decay);
// Adjustment step for theta: No dead neurons are made.
void adjust_theta(shallow_nn *nn, double *c, double *theta);
// Local solver for NPSC
void local_solver(shallow_nn *nn, double *c, double *theta, schwarz *sc, double *r);

// Para-range subroutine (Distribute 0, ..., n-1 into nblocks blocks)
void para_range(int n, int nblocks, int blockid, int *ista, int *iend);