
# GPU 1 的任务列表
GPU1_TASKS=(
    "old 0.15 5 hard internlm-7b-8k all all 4 20 0.75"
    "old 0.1 10 soft internlm-7b-8k all all 4 20 0.75"
    "gpt 0.25 15 soft internlm-7b-8k all all 4 20 0.75"
    "v2 0.1 10 soft internlm-7b-8k all all 4 20 0.75"
)

# 函数：在指定 GPU 上执行任务列表
execute_gpu_tasks() {
    local gpu_id=$1
    local python_script=$2
    shift 2
    local tasks=("$@")
    
    echo "[$(date)] Starting tasks on GPU $gpu_id using script: $python_script"
    
    # 获取脚本名称（不含路径和扩展名）用于日志命名
    local script_name=$(basename "$python_script" .py)
    
    for task in "${tasks[@]}"; do
        # 解析任务参数
        IFS=' ' read -r -a params <<< "$task"
        local mode="${params[0]}"
        local gamma="${params[1]}"
        local delta="${params[2]}"
        local bl_type="${params[3]}"
        local model="${params[4]}"
        local dataset="${params[5]}"
        local custom_text="${params[6]}"
        
        # 根据脚本类型判断是否需要额外参数
        local has_extra_params=false
        if [[ "$python_script" == *"pred2_rougeL_chunk.py"* ]]; then
            has_extra_params=true
            local K="${params[7]}"
            local chunk_size="${params[8]}"
            local alpha="${params[9]}"
        fi
        
        # 生成任务ID
        if [ "$has_extra_params" = true ]; then
            local task_id="${mode}_${gamma}_${delta}_${bl_type}_${model}_${dataset}_${alpha}_${custom_text}"
        else
            local task_id="${mode}_${gamma}_${delta}_${bl_type}_${model}_${dataset}_${custom_text}"
        fi
        
        echo "[$(date)] GPU $gpu_id: Starting task $task_id with $python_script"
        
        # 执行任务 - 根据脚本类型传递不同参数
        if [ "$has_extra_params" = true ]; then
            # pred2_rougeL_chunk.py - 传递所有参数
            CUDA_VISIBLE_DEVICES=$gpu_id python $python_script \
                --mode $mode \
                --gamma $gamma \
                --delta $delta \
                --bl_type $bl_type \
                --model $model \
                --dataset "$dataset" \
                --custom_text "$custom_text" \
                --K $K \
                --chunk_size $chunk_size \
                --alpha $alpha \
                > "${LOG_DIR}/gpu${gpu_id}_${script_name}_${task_id}.log" 2>&1
        else
            # pred.py - 只传递基本参数
            CUDA_VISIBLE_DEVICES=$gpu_id python $python_script \
                --mode $mode \
                --gamma $gamma \
                --delta $delta \
                --bl_type $bl_type \
                --model $model \
                --dataset "$dataset" \
                --custom_text "$custom_text" \
                > "${LOG_DIR}/gpu${gpu_id}_${script_name}_${task_id}.log" 2>&1
        fi
        
        local exit_code=$?
        if [ $exit_code -eq 0 ]; then
            echo "[$(date)] GPU $gpu_id: ✓ Completed task $task_id"
        else
            echo "[$(date)] GPU $gpu_id: ✗ Failed task $task_id (exit code: $exit_code)"
        fi
    done
    
    echo "[$(date)] All tasks completed on GPU $gpu_id"
}

# 导出函数，以便在子shell中使用
export -f execute_gpu_tasks
export LOG_DIR

if [ ${#GPU1_TASKS[@]} -gt 0 ]; then
    execute_gpu_tasks 1 "$GPU1_SCRIPT" "${GPU1_TASKS[@]}" &
    gpu1_pid=$!
fi