import PCAMethods
import numpy as np
import matplotlib.pyplot as plt

alphas = np.around(np.linspace(1,3,num=21), 2)
signal_strengths = np.around(10**np.linspace(0,2,num=21),2)

def plot_res(res, label):
    means = [np.mean(res[key]) for key in res.keys()]
    lower = [max(0, np.mean(res[key])-np.std(res[key])) for key in res.keys()]
    upper = [min(1, np.mean(res[key])+np.std(res[key])) for key in res.keys()]
    plt.plot(res.keys(), means, label=label)
    plt.fill_between(res.keys(), lower, upper, alpha=0.5)

def AlphaDep_Ours(p, n, signal, R=500, P=50, N=50, num_reps = 10, printer=False):
    res = {alpha: [] for alpha in alphas}
    for alpha in alphas:
        for rep in range(num_reps):
            X, u = PCAMethods.GenerateMatrix(p, n, alpha, [signal])
            u_est = PCAMethods.Our_method(X, R=R, P=P, N=N)
            res[alpha].append(1-np.dot(u, u_est[:,0])**2)
        if printer: print(alpha, res[alpha])
    return res

def SignalDep_Ours(p, n, alpha, R=500, P=50, N=50, num_reps = 10, printer=False):
    res = {signal: [] for signal in signal_strengths}
    for signal in res.keys():
        for rep in range(num_reps):
            X, u = PCAMethods.GenerateMatrix(p, n, alpha, [signal])
            u_est = PCAMethods.Our_method(X, R=R, P=P, N=N)
            res[signal].append(1-np.dot(u, u_est[:,0])**2)
        if printer: print(signal, res[signal])
    return res

def AlphaDep_ECA(p, n, signal, num_reps = 10, printer=False):
    res = {alpha: [] for alpha in alphas}
    for alpha in alphas:
        for rep in range(num_reps):
            X, u = PCAMethods.GenerateMatrix(p, n, alpha, [signal])
            u_est = PCAMethods.ECA_method(X)
            res[alpha].append(1-np.dot(u, u_est[:,0])**2)
        if printer: print(alpha, res[alpha])
    return res

def SignalDep_ECA(p, n, alpha, num_reps = 10, printer=False):
    res = {signal: [] for signal in signal_strengths}
    for signal in res.keys():
        for rep in range(num_reps):
            X, u = PCAMethods.GenerateMatrix(p, n, alpha, [signal])
            u_est = PCAMethods.ECA_method(X)
            res[signal].append(1-np.dot(u, u_est[:,0])**2)
        if printer: print(signal, res[signal])
    return res

def AlphaDep_RPCA(p, n, signal, num_reps = 10, printer=False):
    res = {alpha: [] for alpha in alphas}
    for alpha in alphas:
        for rep in range(num_reps):
            X, u = PCAMethods.GenerateMatrix(p, n, alpha, [signal])
            u_est = PCAMethods.RPCA_method(X)
            res[alpha].append(1-np.dot(u, u_est[:,0])**2)
        if printer: print(alpha, res[alpha])
    return res

def SignalDep_RPCA(p, n, alpha, num_reps = 10, printer=False):
    res = {signal: [] for signal in signal_strengths}
    for signal in res.keys():
        for rep in range(num_reps):
            X, u = PCAMethods.GenerateMatrix(p, n, alpha, [signal])
            u_est = PCAMethods.RPCA_method(X)
            res[signal].append(1-np.dot(u, u_est[:,0])**2)
        if printer: print(signal, res[signal])
    return res

def AlphaDep_Minsker(p, n, signal, k=10, nu=0.5, num_reps = 10, printer=False):
    res = {alpha: [] for alpha in alphas}
    for alpha in alphas:
        for rep in range(num_reps):
            X, u = PCAMethods.GenerateMatrix(p, n, alpha, [signal])
            u_est = PCAMethods.Minsker_method(X, NU = [nu], NUM_GROUPS = k)[0]
            res[alpha].append(1-np.dot(u, u_est[:,0])**2)
        if printer: print(alpha, res[alpha])
    return res

def SignalDep_Minsker(p, n, alpha, k=10, nu=0.5, num_reps = 10, printer=False):
    res = {signal: [] for signal in signal_strengths}
    for signal in res.keys():
        for rep in range(num_reps):
            X, u = PCAMethods.GenerateMatrix(p, n, alpha, [signal])
            u_est = PCAMethods.Minsker_method(X, NU = [nu], NUM_GROUPS = k)[0]
            res[signal].append(1-np.dot(u, u_est[:,0])**2)
        if printer: print(signal, res[signal])
    return res

def AlphaDep_SampleCov(p, n, signal, num_reps = 10, printer=False):
    res = {alpha: [] for alpha in alphas}
    for alpha in alphas:
        for rep in range(num_reps):
            X, u = PCAMethods.GenerateMatrix(p, n, alpha, [signal])
            u_est = PCAMethods.Sample_Cov_method(X)
            res[alpha].append(1-np.dot(u, u_est[:,0])**2)
        if printer: print(alpha, res[alpha])
    return res

def SignalDep_SampleCov(p, n, alpha, num_reps = 10, printer=False):
    res = {signal: [] for signal in signal_strengths}
    for signal in res.keys():
        for rep in range(num_reps):
            X, u = PCAMethods.GenerateMatrix(p, n, alpha, [signal])
            u_est = PCAMethods.Sample_Cov_method(X)
            res[signal].append(1-np.dot(u,u_est[:,0])**2)
        if printer: print(signal, res[signal])
    return res

def RDep(Rmax, p, n, alpha, signal, P, N):
    X, u = PCAMethods.GenerateMatrix(p, n, alpha, [signal])
    u_ests = PCAMethods.Our_method(X, R = Rmax, P = P, N = N, run = True)
    yvals = []
    for u_est in u_ests:
        yvals.append(1-np.dot(u, u_est)**2)
    return list(range(Rmax)), yvals
