The core functions, implementing the PCA algorithms from our paper, from Minsker (2015), Han and Liu (2018), Robust PCA, and based on the sample covariance matrix, are contained in PCAMethods.py. This file also contains a function to generate data and ground-truth principal components from the information-plus-noise model in Section 3.1 of our paper.

These functions are packaged together in PaperFigs.py and then called by Figure1.ipynb, Figure2.ipynb, Figure4.ipynb, and Figure5.ipynb. The titles of these Jupyter files reflect the figures of the paper and Supplementary Information that they illustrate. Figures 6 and 7 of the Supplementary Information show additional uses of Figure2.ipynb, while Figures 8 and 9 of the Supplementary Information show additional usages of Figure4.ipynb.

## Drosophila data set
The file Drosophila.py loads the local file "GENDX000068_GeneMatrix_FPKM.txt", which contains the RNA count data from McLaughlin et al. (2021) which is analyzed in Section 5.1 of our paper. After loading, it performs split-half reproducibility analysis using our PCA algorithm.

## MICrONs synaptic connectivity data
The Jupyter notebook provided uses the MICrONS Phase 1 V1 dataset, a dense electron microscopy reconstruction of mouse visual cortex, to extract and analyze structural connectivity. Using the CAVEclient API, it loads segmented neurons and synapse metadata, constructs a directed connectivity graph, and compares our method to Minsker's approach in terms of split-half reproducibility on the resulting directed connectivity matrices.
