# Learning proportional analogies
## 1. Install necessary Python packages

- Create a virtual environment and activate it (recommended)
- Install the libraries by PIP: `pip3 install - requirements.txt`

## 2. Generate a dataset
Depending on your eagerness, you can choose how many colours and shapes you want your dataset to have. For simple experiments we recommend a full dataset 
of 1 shape and 2 colours:

`python3 build_analogy.py 1 2 --export_path data/`

Then you can generate the dataset for fine-tuning llms (optional, only do it if you wish to fine-tune LLMs later) for verification:

`python3 build_dataset.py data/ --type 1hot --export_path data/finetune/`

Aaand for generation:

`python3 build_dataset.py data/ --type gen_1hot_mcls --export_path data/finetune/`

## 3. Train and evaluate models for analogy verification
### a. Feed-forward (our architecture) model
It's easy here:

`python3 -i model_ff_cls.py data/ --export_path models/ff/cls/`

### b. Finetune LLMs
To finetune LLMs, you run the following command. Remember to put the huggingface model. By default it's _meta-llama/Llama-3.1-8B_. This requires CUDA:

`python3 model_llm_cls_tune.py --model <huggingface_model> --dataset data/finetune/1hot/ --export_path models/finetuned/cls/`

And to evaluate the finetuned model, you run the following command. Use the last checkpoint:

`python3 model_llm_cls_eval.py models/finetuned/cls/<checkpoint>/ --export_path eval/finetuned/cls/`

## 4. Train and evaluate models for analogy generation
### a. Feed-forward (our architecture) model
It's easy here:

`python3 -i model_ff_gen.py data/ --export_path models/ff/gen/`

### b. Finetune LLMs
To finetune LLMs, you run the following command. Remember to put the huggingface model. By default it's _meta-llama/Llama-3.1-8B_. This requires CUDA:

`python3 model_llm_mcls_tune.py --model <huggingface_model> --dataset data/finetune/gen_1hot_mcls/ --export_path models/finetuned/gen/`

And to evaluate the finetuned model, you run the following command. Use the last checkpoint:

`python3 model_llm_mcls_eval.py models/finetuned/gen/<checkpoint>/ --export_path eval/finetuned/gen/`

## 5. Do zero-shot classification for evaluation

Run the command below with your favourite Instruct model from huggingface:

`python3 model_llm_instruct.py data/finetune/1hot/ --model <your fav model>`
