import torch

from diffusers import StableVideoDiffusionPipeline
from diffusers.utils import load_image, export_to_video

pipe = StableVideoDiffusionPipeline.from_pretrained(
    "stabilityai/stable-video-diffusion-img2vid", torch_dtype=torch.float16, variant="fp16"
)
pipe.enable_model_cpu_offload()

# Load the conditioning image
image = load_image("test.png")
image = image.resize((512, 512))

generator = torch.manual_seed(42)
# fp16 inference
from torch.cuda.amp import autocast
pipe.to(torch.float16)
frames = pipe(image, decode_chunk_size=8, generator=generator, num_frames=8, height=512, width=512).frames[0]

export_to_video(frames, "generated.mp4", fps=7)