import torch

from diffusers import StableVideoDiffusionPipeline
from diffusers.utils import load_image, export_to_video

pipe = StableVideoDiffusionPipeline.from_pretrained(
    "stabilityai/stable-video-diffusion-img2vid", torch_dtype=torch.float16, variant="fp16"
)
pipe.enable_model_cpu_offload()

# Load the conditioning image
image = load_image("condition.png")
image = image.resize((384, 384))

generator = torch.manual_seed(233)
print(pipe.scheduler.init_noise_sigma)
frames = pipe(image, height=384, width=384, decode_chunk_size=8, num_frames=6, generator=generator).frames[0]

export_to_video(frames, "generated.mp4", fps=7)