import os
import numpy as np
from PIL import Image
path = "data/gobjaverse/data/0/10510/00000/00000.png"

img = np.array(Image.open(path))
bg_color = np.array([1.0, 1.0, 1.0], dtype=np.float32)
img = img.astype(np.float32) / 255.0  # [0, 1]
if img.shape[-1] == 4:
    alpha = img[..., 3:4]
    img = img[..., :3] * alpha + bg_color * (1 - alpha)
img = (img * 255).astype(np.uint8)
img = Image.fromarray(img)
img.save('test.png')