import torch
# def sample_points_on_sphere(n_pts):
#     # 使用均匀分布随机生成点的角度
#     theta = torch.acos(2 * torch.rand(n_pts) - 1)  # theta角从0到pi
#     theta = torch.acos(torch.linspace(-1, 1, n_pts))  # theta角从0到pi
#     phi = 2 * torch.pi * torch.linspace(0, 1, n_pts)  # phi角从0到2pi

#     # 将球坐标转换为笛卡尔坐标
#     x = torch.sin(theta) * torch.cos(phi)
#     y = torch.sin(theta) * torch.sin(phi)
#     z = torch.cos(theta)

#     # 组合x, y, z到一个tensor中
#     points = torch.stack((x, y, z), dim=1)

#     return points
def fibonacci_sphere(n_pts):
    # 使用Fibonacci序列方法来近似均匀分布点
    indices = torch.arange(0, n_pts, dtype=torch.float32)
    phi = torch.acos(1 - 2*(indices+0.5)/n_pts)  # phi是从0到pi
    golden_ratio = (1 + 5**0.5) / 2
    theta = 2 * torch.pi * indices / golden_ratio  # theta是从0到2pi

    # 将球坐标转换为笛卡尔坐标
    x = torch.sin(phi) * torch.cos(theta)
    y = torch.sin(phi) * torch.sin(theta)
    z = torch.cos(phi)

    # 组合x, y, z到一个tensor中
    points = torch.stack((x, y, z), dim=1)

    return points

# def sample_points_on_sphere(n_pts):
#     # 使用均匀分布随机生成点的角度
#     theta = torch.acos(2 * torch.rand(n_pts) - 1)  # theta角从0到pi

#     phi = 2 * torch.pi * torch.rand(n_pts)  # phi角从0到2pi

#     # 将球坐标转换为笛卡尔坐标
#     x = torch.sin(theta) * torch.cos(phi)
#     y = torch.sin(theta) * torch.sin(phi)
#     z = torch.cos(theta)

#     # 组合x, y, z到一个tensor中
#     points = torch.stack((x, y, z), dim=1)

#     return points

n_pts = 200  # 按需更改点的数量
points_on_sphere = fibonacci_sphere(n_pts)
# visualization
import matplotlib.pyplot as plt
fig = plt.figure()
ax = fig.add_subplot(111, projection='3d')
ax.scatter(points_on_sphere[:, 0], points_on_sphere[:, 1], points_on_sphere[:, 2])
plt.savefig("sphere.png")


print(points_on_sphere)  # 打印球面上的点
